# $Id: id3tag.m4,v 1.3 2004/02/13 14:17:22 jylefort Exp $
#
# This file is part of streamtuner-local.
#
# Copyright (c) 2003, 2004 Jean-Yves Lefort.
#
# As a special exception to the streamtuner-local licensing terms,
# Jean-Yves Lefort gives unlimited permission to copy, distribute and
# modify this file.

dnl AM_PATH_ID3TAG([MINIMUM-VERSION], [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND], [ACTION-IF-WITHOUT])
dnl
AC_DEFUN(AM_PATH_ID3TAG,
[AC_ARG_WITH(id3tag,
AC_HELP_STRING([--with-id3tag=PREFIX], [specify where libid3tag is installed [[autodetect]]]),
[with_id3tag=$withval],
[with_id3tag=yes])

if test "x$with_id3tag" != xno; then
	if test "x$with_id3tag" = xyes; then
		AC_CHECK_FILE(/usr/include/id3tag.h, [ID3TAG_PREFIX=/usr])
		if test -z "$ID3TAG_PREFIX"; then
			AC_CHECK_FILE(/usr/local/include/id3tag.h, [ID3TAG_PREFIX=/usr/local])
		fi
		if test -z "$ID3TAG_PREFIX"; then
			AC_CHECK_FILE(/opt/include/id3tag.h, [ID3TAG_PREFIX=/opt])
		fi
		if test -z "$ID3TAG_PREFIX"; then
			AC_MSG_ERROR([unable to determine the libid3tag prefix: please specify it manually using --with-id3tag=PREFIX])
		fi
	else
		ID3TAG_PREFIX="$with_id3tag"
	fi

	ID3TAG_CFLAGS="-I$ID3TAG_PREFIX/include"
	ID3TAG_LIBS="-L$ID3TAG_PREFIX/lib -lid3tag"

	id3tag_min_version=ifelse([$1],, 0.15.0, [$1])

	ac_save_CFLAGS="$CFLAGS"
	ac_save_LIBS="$LIBS"
	CFLAGS="$CFLAGS $ID3TAG_CFLAGS"
	LIBS="$LIBS $ID3TAG_LIBS"

	AC_MSG_CHECKING([for libid3tag - version >= $id3tag_min_version])

	AC_TRY_RUN([
#include <id3tag.h>

int main () {
  int major, minor, patch;

  if (sscanf("$id3tag_min_version", "%d.%d.%d", &major, &minor, &patch) != 3)
    exit(1); /* bad version string */

  if ((ID3_VERSION_MAJOR << 16) + (ID3_VERSION_MINOR << 8) + ID3_VERSION_PATCH < (major << 16) + (minor << 8) + patch)
    exit(2); /* version too old */

  exit(0);
}
],, [found=no], [found=yes])

	AC_MSG_RESULT($found)

	CFLAGS="$ac_save_CFLAGS"
	LIBS="$ac_save_LIBS"

	if test $found = yes; then
		ifelse([$2],, :, [$2])
	else
		ID3TAG_PREFIX=""
		ID3TAG_CFLAGS=""
		ID3TAG_LIBS=""

		ifelse([$3],, :, [$3])
	fi
else
	ID3TAG_PREFIX=""
	ID3TAG_CFLAGS=""
	ID3TAG_LIBS=""

	ifelse([$4],, :, [$4])
fi

AC_SUBST(ID3TAG_PREFIX)
AC_SUBST(ID3TAG_CFLAGS)
AC_SUBST(ID3TAG_LIBS)])
