/*
 * $Id: st-transfer-api.h,v 1.10 2004/03/26 18:04:57 jylefort Exp $
 *
 * Copyright (c) 2002, 2003 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_TRANSFER_API_H
#define _ST_TRANSFER_API_H

#include <glib.h>

#define ST_TRANSFER_PASS_NEWLINE	(1 << 0)

typedef void (STTransferLineCallback) (const char *line, gpointer data);

typedef struct _STTransferSession STTransferSession;

STTransferSession	*st_transfer_session_new (void);
void			st_transfer_session_free (STTransferSession *session);

gboolean st_transfer_session_get              (STTransferSession *session,
					       const char        *url,
					       unsigned int      flags,
					       char              **headers,
					       char              **body,
					       GError            **err);
gboolean st_transfer_session_get_binary       (STTransferSession *session,
					       const char        *url,
					       unsigned int      flags,
					       char              **headers,
					       guint8            **body,
					       unsigned int      *body_len,
					       GError            **err);
gboolean st_transfer_session_get_by_line      (STTransferSession *session,
					       const char        *url,
					       unsigned int      flags,
					       STTransferLineCallback *header_cb,
					       gpointer          header_data,
					       STTransferLineCallback *body_cb,
					       gpointer          body_data,
					       GError            **err);

char			*st_transfer_escape      (const char        *url);

/* Deprecated API. */

char	 *st_transfer_get_full              (const char             *url,
					     GError                 **err);
gboolean st_transfer_get_lines              (const char             *url,
					     STTransferLineCallback *cb,
					     gpointer               data,
					     GError                 **err);

char	 *st_transfer_get_full_with_session (STTransferSession      *session,
					     const char             *url,
					     GError                 **err);
gboolean st_transfer_get_lines_with_session (STTransferSession      *session,
					     const char             *url,
					     STTransferLineCallback *cb,
					     gpointer               data,
					     GError                 **err);

#endif /* _ST_TRANSFER_API_H */
