/*
 * $Id: sgtk-stock.h,v 1.1.2.2 2004/08/06 18:45:27 jylefort Exp $
 *
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _SGTK_STOCK_H
#define _SGTK_STOCK_H

#include <glib.h>

#define SGTK_STOCK_PREVIOUS		"sgtk-previous"
#define SGTK_STOCK_NEXT			"sgtk-next"

typedef enum
{
  SGTK_STOCK_SOURCE_STOCK,
  SGTK_STOCK_SOURCE_INLINE,
  SGTK_STOCK_SOURCE_THEME
} sGtkStockSourceType;

typedef struct
{
  const char		*stock_id;
  sGtkStockSourceType	source_type;
  const char		*source_stock_id;		/* SGTK_STOCK_SOURCE_STOCK */
  const guint8		*source_inline_data;		/* SGTK_STOCK_SOURCE_INLINE */
  int			source_inline_data_size;	/* SGTK_STOCK_SOURCE_INLINE */
  const char		*source_icon_name;		/* SGTK_STOCK_SOURCE_THEME */
} sGtkStockIcon;

#define SGTK_STOCK_ICON_FROM_STOCK(stock_id, source_stock_id) \
  { stock_id, SGTK_STOCK_SOURCE_STOCK, source_stock_id }
#define SGTK_STOCK_ICON_FROM_INLINE(stock_id, inline_data) \
  { stock_id, SGTK_STOCK_SOURCE_INLINE, NULL, inline_data, sizeof(inline_data) }
#define SGTK_STOCK_ICON_FROM_THEME(stock_id, icon_name) \
  { stock_id, SGTK_STOCK_SOURCE_THEME, NULL, NULL, 0, icon_name }
#define SGTK_STOCK_ICON_END \
  { NULL }
    
void sgtk_stock_init		(void);
void sgtk_stock_register_icons	(const sGtkStockIcon icons[]);

#endif /* _SGTK_STOCK_H */
