#!/bin/sh
#
# ent2h.sh - convert one or more SGML entity sets to a C header
# $Id: ent2h.sh,v 1.1 2004/03/20 18:13:55 jylefort Exp $
#
# Copyright (c) 2004 Jean-Yves Lefort
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
#    may be used to endorse or promote products derived from this software
#    without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
# CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
# ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

cat <<EOF
/*
 * st-entities.h - SGML entities table
 *
 * Generated automatically by ent2h.sh.
 * Do not edit this file directly.
 */

#ifndef _ST_ENTITIES_H
#define _ST_ENTITIES_H

static const struct
{
  const char		*name;
  unsigned long		character;
} entities[] = {
EOF

for f in $@; do
    echo ""
    echo "  /* $f */"
    grep '^<!ENTITY' $f \
	| sed -E 's/^<!ENTITY ([a-zA-Z]+).*"&#([0-9]+);.*$/  { "\1",	\2 },/'
done

cat <<EOF
};

#endif /* _ST_ENTITIES_H */
EOF
