/*
 * $Id: st-preferences.c,v 1.12 2004/01/27 12:29:42 jylefort Exp $
 *
 * Copyright (c) 2003 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <gtk/gtk.h>
#include "st-settings.h"

/*** function declarations ***************************************************/

static void st_preferences_toggle_toggled_h	  (GtkToggleButton  *toggle,
						   gpointer	    data);
static gboolean st_preferences_entry_focus_out_h  (GtkWidget	    *widget,
						   GdkEventFocus    *event,
						   gpointer	    data);

/*** implementation **********************************************************/

void
st_preferences_bind_boolean (GtkToggleButton *toggle, gboolean *ptr)
{
  g_return_if_fail(GTK_IS_TOGGLE_BUTTON(toggle));
  g_return_if_fail(ptr != NULL);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(toggle), *ptr);

  g_signal_connect(G_OBJECT(toggle), "toggled",
		   G_CALLBACK(st_preferences_toggle_toggled_h), ptr);
}

static void
st_preferences_toggle_toggled_h (GtkToggleButton *toggle, gpointer data)
{
  gboolean *ptr = data;

  g_return_if_fail(GTK_IS_TOGGLE_BUTTON(toggle));
  g_return_if_fail(ptr != NULL);

  G_LOCK(st_settings);
  *ptr = gtk_toggle_button_get_active(toggle);
  G_UNLOCK(st_settings);
}

void
st_preferences_bind_string (GtkEntry *entry, char **ptr)
{
  g_return_if_fail(GTK_IS_ENTRY(entry));
  g_return_if_fail(ptr != NULL);

  gtk_entry_set_text(entry, *ptr ? *ptr : "");

  g_signal_connect(G_OBJECT(entry), "focus-out-event",
		   G_CALLBACK(st_preferences_entry_focus_out_h), ptr);
}

static gboolean
st_preferences_entry_focus_out_h (GtkWidget *widget,
				  GdkEventFocus *event,
				  gpointer data)
{
  char **ptr = data;
  const char *str;

  g_return_val_if_fail(GTK_IS_ENTRY(widget), FALSE);
  g_return_val_if_fail(ptr != NULL, FALSE);

  str = gtk_entry_get_text(GTK_ENTRY(widget));

  G_LOCK(st_settings);
  g_free(*ptr);
  *ptr = str[0] ? g_strdup(str) : NULL;
  G_UNLOCK(st_settings);

  return FALSE;
}
