/*
 * $Id: st-preferences-tab.c,v 1.10 2004/01/05 19:44:10 jylefort Exp $
 *
 * Copyright (c) 2003 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <gtk/gtk.h>
#include "st-preferences-tab.h"
#include "sgtk-hig.h"

/*** function declarations ***************************************************/

static void st_preferences_tab_init (STPreferencesTab *tab);

/*** implementation **********************************************************/

GType
st_preferences_tab_get_type (void)
{
  static GType preferences_tab_type = 0;
  
  if (! preferences_tab_type)
    {
      static const GTypeInfo preferences_tab_info = {
	sizeof(STPreferencesTabClass),
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	sizeof(STPreferencesTab),
	0,
	(GInstanceInitFunc) st_preferences_tab_init,
      };

      preferences_tab_type = g_type_register_static(GTK_TYPE_EVENT_BOX,
						    "STPreferencesTab",
						    &preferences_tab_info,
						    0);
    }
  
  return preferences_tab_type;
}

static void
st_preferences_tab_init (STPreferencesTab *tab)
{
  tab->label = NULL;
}

/*
 * Constructs TAB->label using PIXBUF and TEXT.
 *
 * A reference to PIXBUF will be owned (actually, by the
 * gtk_image_new_from_pixbuf() call).
 */
void
st_preferences_tab_construct_label (STPreferencesTab *tab,
				    GdkPixbuf *pixbuf,
				    const char *text)
{
  GtkWidget *image, *label;

  g_return_if_fail(ST_IS_PREFERENCES_TAB(tab));
  g_return_if_fail(pixbuf != NULL);
  g_return_if_fail(text != NULL);
  
  tab->label = gtk_vbox_new(FALSE, 0);
  
  image = gtk_image_new_from_pixbuf(pixbuf);
  label = gtk_label_new(text);

  gtk_box_pack_start_defaults(GTK_BOX(tab->label), image);
  gtk_box_pack_start_defaults(GTK_BOX(tab->label), label);

  gtk_widget_show(image);
  gtk_widget_show(label);
  gtk_widget_show(tab->label);

  gtk_container_set_border_width(GTK_CONTAINER(tab->label), SGTK_HIG_CONTROL_SPACING);
}
