/*
 * $Id: st-preferences-dialog.c,v 1.19 2004/01/28 14:00:26 jylefort Exp $
 *
 * Copyright (c) 2003 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include <gtk/gtk.h>
#include "gettext.h"
#include "sgtk-hig.h"
#include "st-preferences-dialog.h"
#include "st-general-tab.h"
#include "st-network-tab.h"
#include "st-programs-tab.h"
#include "st-preferences-tab.h"
#include "st-settings.h"

/*** variable declarations ***************************************************/

static GObjectClass *parent_class = NULL;

/*** function declarations ***************************************************/

static void st_preferences_dialog_class_init	(STPreferencesDialogClass *class);
static void st_preferences_dialog_init		(STPreferencesDialog  *dialog);
static void st_preferences_dialog_unrealize	(GtkWidget	      *widget);

static void st_preferences_dialog_append_tab	(STPreferencesDialog  *dialog,
						 GtkWidget	      *tab);

/*** implementation **********************************************************/

GType
st_preferences_dialog_get_type (void)
{
  static GType preferences_dialog_type = 0;
  
  if (! preferences_dialog_type)
    {
      static const GTypeInfo preferences_dialog_info = {
	sizeof(STPreferencesDialogClass),
	NULL,
	NULL,
	(GClassInitFunc) st_preferences_dialog_class_init,
	NULL,
	NULL,
	sizeof(STPreferencesDialog),
	0,
	(GInstanceInitFunc) st_preferences_dialog_init,
      };
      
      preferences_dialog_type = g_type_register_static(SGTK_TYPE_DIALOG,
						       "STPreferencesDialog",
						       &preferences_dialog_info,
						       0);
    }

  return preferences_dialog_type;
}

static void
st_preferences_dialog_class_init (STPreferencesDialogClass *class)
{
  GtkWidgetClass *widget_class = GTK_WIDGET_CLASS(class);

  parent_class = g_type_class_peek_parent(class);

  widget_class->unrealize = st_preferences_dialog_unrealize;
}

static void
st_preferences_dialog_init (STPreferencesDialog *dialog)
{
  gtk_dialog_add_button(GTK_DIALOG(dialog), GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE);

  gtk_window_set_title(GTK_WINDOW(dialog), _("streamtuner Preferences"));

  dialog->general_tab = st_general_tab_new();
  dialog->programs_tab = st_programs_tab_new();
  dialog->network_tab = st_network_tab_new();

  dialog->notebook = gtk_notebook_new();
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(dialog->notebook), GTK_POS_LEFT);

  st_preferences_dialog_append_tab(dialog, dialog->general_tab);
  st_preferences_dialog_append_tab(dialog, dialog->programs_tab);
  st_preferences_dialog_append_tab(dialog, dialog->network_tab);

  gtk_notebook_set_current_page(GTK_NOTEBOOK(dialog->notebook),
				st_settings.selected_preferences_page);

  gtk_container_add(GTK_CONTAINER(SGTK_DIALOG(dialog)->contents), dialog->notebook);
  gtk_widget_show(dialog->notebook);
  
  gtk_window_set_default_size(GTK_WINDOW(dialog),
			      st_settings.preferences_window_width,
			      st_settings.preferences_window_height);
}

static void
st_preferences_dialog_unrealize (GtkWidget *widget)
{
  STPreferencesDialog *dialog = ST_PREFERENCES_DIALOG(widget);

  st_settings.selected_preferences_page = gtk_notebook_get_current_page(GTK_NOTEBOOK(dialog->notebook));
  gtk_window_get_size(GTK_WINDOW(dialog),
		      &st_settings.preferences_window_width,
		      &st_settings.preferences_window_height);

  GTK_WIDGET_CLASS(parent_class)->unrealize(widget);
}

static void
st_preferences_dialog_append_tab (STPreferencesDialog *dialog, GtkWidget *tab)
{
  g_return_if_fail(ST_IS_PREFERENCES_DIALOG(dialog));
  g_return_if_fail(GTK_IS_NOTEBOOK(dialog->notebook));
  g_return_if_fail(ST_IS_PREFERENCES_TAB(tab));

  gtk_notebook_append_page(GTK_NOTEBOOK(dialog->notebook),
			   tab,
			   ST_PREFERENCES_TAB(tab)->label);
  gtk_widget_show(tab);
}

GtkWidget *
st_preferences_dialog_new (GtkWindow *parent)
{
  STPreferencesDialog *dialog;

  dialog = g_object_new(ST_TYPE_PREFERENCES_DIALOG, NULL);

  if (parent)
    gtk_window_set_transient_for(GTK_WINDOW(dialog), parent);

  return GTK_WIDGET(dialog);
}
