/*
 * $Id: st-handlers.c,v 1.9 2004/01/05 19:44:10 jylefort Exp $
 *
 * Copyright (c) 2002, 2003 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "gettext.h"
#include "sg-util.h"
#include "st-plugin.h"
#include "st-dialog.h"
#include "st-handler.h"
#include "st-handlers.h"

/*** variable declarations ***************************************************/

GSList *st_handlers_list = NULL;

/*** API implementation ******************************************************/

/*
 * FIXME: at the next API break we must change this prototype to
 * 	gboolean st_handlers_add (STHandler *handler, GError **err)
 * (returning FALSE if the handler can't be validated)
 */
void
st_handlers_add (STHandler *handler)
{
  GError *err = NULL;

  if (st_handler_validate(handler, &err))
    st_handlers_list = g_slist_append(st_handlers_list, handler);
  else
    {
      g_assert(st_plugin_current != NULL);
      
      st_error_dialog(_("A plugin error has occurred."),
		      _("In <i>%s</i>, a handler is malformed and can't be registered (%s).\n"
		      "\n"
		      "You should report this problem to the plugin maintainer."),
		      st_plugin_current, err->message);
      g_error_free(err);
    }
}

/*** private implementation **************************************************/

void
st_handlers_load_static (void)
{
#ifdef WITH_STATIC_SHOUTCAST
  extern STPluginInitCallback shoutcast_init;
  gboolean status;

  status = shoutcast_init(NULL);
  g_return_if_fail(status == TRUE);
#endif
}

STHandler *
st_handlers_find_by_name (const char *name)
{
  GSList *l;

  g_return_val_if_fail(name != NULL, NULL);

  SG_LIST_FOREACH(l, st_handlers_list)
    {
      STHandler *handler = l->data;

      g_return_val_if_fail(handler->name != NULL, NULL);

      if (! strcmp(handler->name, name))
	return handler;
    }

  return NULL;
}
