/*
 * $Id: st-handler-event.h,v 1.7 2004/01/27 14:16:42 jylefort Exp $
 *
 * Copyright (c) 2002, 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_HANDLER_EVENT_H
#define _ST_HANDLER_EVENT_H

#include "st-handler.h"

#define st_handler_event_is_bound(handler, event) \
	((handler)->callbacks[(event)].cb != NULL)

gboolean	st_handler_event_refresh	  (STHandler	*handler,
						   STCategory	*category,
						   GNode	**categories,
						   GList	**streams,
						   GError	**err);
STCategory	*st_handler_event_category_new	  (STHandler	*handler);
void		st_handler_event_category_free	  (STHandler	*handler,
						   STCategory	*category);
STStream	*st_handler_event_stream_new	  (STHandler	*handler);
void		st_handler_event_stream_field_get (STHandler	*handler,
						   STStream	*stream,
						   STHandlerField *field,
						   GValue	*value);
void		st_handler_event_stream_field_set (STHandler	*handler,
						   STStream	*stream,
						   STHandlerField *field,
						   GValue	*value);
void		st_handler_event_stream_free	  (STHandler	*handler,
						   STStream	*stream);
gboolean	st_handler_event_stream_tune_in	  (STHandler	*handler,
						   STStream	*stream,
						   GError	**err);
gboolean	st_handler_event_stream_tune_in_multiple (STHandler *handler,
							  GSList    *streams,
							  GError    **err);
gboolean	st_handler_event_stream_record	  (STHandler	*handler,
						   STStream	*stream,
						   GError	**err);
gboolean	st_handler_event_stream_browse	  (STHandler	*handler,
						   STStream	*stream,
						   GError	**err);
gpointer	st_handler_event_thread_begin	  (STHandler	*handler);
void		st_handler_event_thread_end	  (STHandler	*handler,
						   gpointer	data);

#endif /* _ST_HANDLER_EVENT_H */
