/*
 * $Id: st-browser-tab-label.c,v 1.1 2004/01/30 15:04:36 jylefort Exp $
 *
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <gtk/gtk.h>
#include "gettext.h"
#include "sgtk-blinking-image.h"
#include "sgtk-hig.h"
#include "sgtk-util.h"
#include "st-browser-tab-label.h"

/*** type definitions ********************************************************/

enum {
  PROP_0,
  PROP_HANDLER
};

/*** variable declarations ***************************************************/

static GObjectClass *parent_class = NULL;

/*** function declarations ***************************************************/

static void st_browser_tab_label_class_init (STBrowserTabLabelClass *class);
static void st_browser_tab_label_init (STBrowserTabLabel *tab_label);

static GObject *st_browser_tab_label_constructor (GType type,
						  guint n_construct_properties,
						  GObjectConstructParam *construct_params);
static void st_browser_tab_label_set_property (GObject *object,
					       guint prop_id,
					       const GValue *value,
					       GParamSpec *pspec);

/*** implementation **********************************************************/

GType
st_browser_tab_label_get_type (void)
{
  static GType browser_tab_label_type = 0;
  
  if (! browser_tab_label_type)
    {
      static const GTypeInfo browser_tab_label_info = {
	sizeof(STBrowserTabLabelClass),
	NULL,
	NULL,
	(GClassInitFunc) st_browser_tab_label_class_init,
	NULL,
	NULL,
	sizeof(STBrowserTabLabel),
	0,
	(GInstanceInitFunc) st_browser_tab_label_init,
      };
      
      browser_tab_label_type = g_type_register_static(GTK_TYPE_HBOX,
						      "STBrowserTabLabel",
						      &browser_tab_label_info,
						      0);
    }

  return browser_tab_label_type;
}

static void
st_browser_tab_label_class_init (STBrowserTabLabelClass *class)
{
  GObjectClass *object_class = G_OBJECT_CLASS(class);

  parent_class = g_type_class_peek_parent(class);

  object_class->constructor = st_browser_tab_label_constructor;
  object_class->set_property = st_browser_tab_label_set_property;

  g_object_class_install_property(object_class,
				  PROP_HANDLER,
				  g_param_spec_pointer("handler",
						       "Handler",
						       _("The tab label's STHandler object"),
						       G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
st_browser_tab_label_init (STBrowserTabLabel *tab_label)
{
  tab_label->handler = NULL;
  tab_label->image = NULL;
}

static GObject *
st_browser_tab_label_constructor (GType type,
				  guint n_construct_properties,
				  GObjectConstructParam *construct_params)
{
  GObject *object;
  STBrowserTabLabel *tab_label;
  GtkWidget *label;

  object = G_OBJECT_CLASS(parent_class)->constructor(type,
						     n_construct_properties,
						     construct_params);

  tab_label = ST_BROWSER_TAB_LABEL(object);

  g_return_val_if_fail(tab_label->handler != NULL, NULL);

  tab_label->image = sgtk_blinking_image_new();
  if (tab_label->handler->pixbuf)
    {
      GdkPixbuf *scaled;

      scaled = sgtk_pixbuf_scale(tab_label->handler->pixbuf, GTK_ICON_SIZE_MENU);
      sgtk_blinking_image_set_from_pixbuf(SGTK_BLINKING_IMAGE(tab_label->image), scaled);
      g_object_unref(scaled);
    }

  label = gtk_label_new(tab_label->handler->label);

  gtk_misc_set_alignment(GTK_MISC(tab_label->image), 0, 0.5);
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);

  gtk_box_pack_start(GTK_BOX(tab_label), tab_label->image, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(tab_label), label, TRUE, TRUE, 0);

  gtk_widget_show(tab_label->image);
  gtk_widget_show(label);

  return object;
}

static void
st_browser_tab_label_set_property (GObject *object,
				   guint prop_id,
				   const GValue *value,
				   GParamSpec *pspec)
{
  STBrowserTabLabel *tab_label = ST_BROWSER_TAB_LABEL(object);

  switch (prop_id)
    {
    case PROP_HANDLER:
      tab_label->handler = g_value_get_pointer(value);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
      break;
    }
}

GtkWidget *
st_browser_tab_label_new (STHandler *handler)
{
  return g_object_new(ST_TYPE_BROWSER_TAB_LABEL,
		      "handler", handler,
		      "spacing", SGTK_HIG_UNIT / 2,
		      NULL);
}

void
st_browser_tab_label_set_blinking (STBrowserTabLabel *tab_label,
				   gboolean blinking)
{
  g_return_if_fail(ST_IS_BROWSER_TAB_LABEL(tab_label));

  sgtk_blinking_image_set_blinking(SGTK_BLINKING_IMAGE(tab_label->image), blinking);
}

void
st_browser_tab_label_set_icon_visible (STBrowserTabLabel *tab_label,
				       gboolean visible)
{
  g_return_if_fail(ST_IS_BROWSER_TAB_LABEL(tab_label));

  g_object_set(tab_label->image,
	       "visible", visible,
	       NULL);
}
