/*
 * $Id: st-about-dialog.c,v 1.27 2004/01/28 11:33:54 jylefort Exp $
 *
 * Copyright (c) 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include <gtk/gtk.h>
#include "art/streamtuner_logo.h"
#include "gettext.h"
#include "sgtk-dialog.h"
#include "sgtk-hig.h"
#include "st-about-dialog.h"
#include "st-plugins.h"
#include "st-handlers.h"
#include "st-link.h"
#include "st-settings.h"
#include "sg-util.h"

/*** function declarations ***************************************************/

static void      st_about_dialog_init		(STAboutDialog *dialog);

static GtkWidget *st_about_dialog_make_logo	(void);
static char      *st_about_dialog_make_info	(void);

/*** implementation **********************************************************/

GType
st_about_dialog_get_type (void)
{
  static GType about_dialog_type = 0;
  
  if (! about_dialog_type)
    {
      static const GTypeInfo about_dialog_info = {
	sizeof(STAboutDialogClass),
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	sizeof(STAboutDialog),
	0,
	(GInstanceInitFunc) st_about_dialog_init,
      };
      
      about_dialog_type = g_type_register_static(SGTK_TYPE_DIALOG,
						 "STAboutDialog",
						 &about_dialog_info,
						 0);
    }

  return about_dialog_type;
}

static void
st_about_dialog_init (STAboutDialog *dialog)
{
  GtkWidget *box;
  GtkWidget *close;
  GtkWidget *logo;
  GtkWidget *version;
  GtkWidget *link;
  GtkWidget *info;
  char *tmp;

  close = gtk_dialog_add_button(GTK_DIALOG(dialog), GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE);
  gtk_window_set_default(GTK_WINDOW(dialog), close);

  gtk_window_set_title(GTK_WINDOW(dialog), _("About streamtuner"));
  gtk_window_set_resizable(GTK_WINDOW(dialog), FALSE);

  /* create the logo */

  logo = st_about_dialog_make_logo();

  /* create the version and copyright */

  tmp = g_strdup_printf(_("\nversion %s\n%s\n"), VERSION, COPYRIGHT);
  version = gtk_label_new(tmp);
  g_free(tmp);

  gtk_label_set_selectable(GTK_LABEL(version), TRUE);
  gtk_label_set_justify(GTK_LABEL(version), GTK_JUSTIFY_CENTER);

  /* create the homepage link */

  link = st_link_new();
  st_link_set_text(ST_LINK(link), PACKAGE_HOME);
  st_link_set_uri(ST_LINK(link), PACKAGE_HOME);

  /* create the dynamic info */

  tmp = st_about_dialog_make_info();
  info = gtk_label_new(tmp);
  g_free(tmp);

  gtk_label_set_selectable(GTK_LABEL(info), TRUE);
  gtk_label_set_use_markup(GTK_LABEL(info), TRUE);
  gtk_label_set_justify(GTK_LABEL(info), GTK_JUSTIFY_CENTER);

  /* pack the widgets */

  box = gtk_vbox_new(FALSE, 0);

  gtk_box_pack_start(GTK_BOX(box), logo, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(box), version, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(box), link, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(box), info, FALSE, FALSE, 0);

  gtk_container_add(GTK_CONTAINER(SGTK_DIALOG(dialog)->contents), box);
  gtk_widget_show_all(box);
}

static GtkWidget *
st_about_dialog_make_logo (void)
{
  GtkWidget *image;
  GtkWidget *event_box;
  GdkPixbuf *logo; /* fff000 */
  GdkColor bg = { 0, 0xFFFF, 0xF000, 0x0000 };

  logo = gdk_pixbuf_new_from_inline(sizeof(art_streamtuner_logo),
				    art_streamtuner_logo,
				    FALSE,
				    NULL);
  g_return_val_if_fail(logo != NULL, NULL);
  
  image = gtk_image_new_from_pixbuf(logo);
  g_object_unref(logo);

  event_box = gtk_event_box_new();
  gtk_widget_modify_bg(event_box, GTK_STATE_NORMAL, &bg);
  gtk_container_add(GTK_CONTAINER(event_box), image);

  gtk_widget_show(image);

  return event_box;
}

static char *
st_about_dialog_make_info (void)
{
  GString *string;
  GSList *l;

  string = g_string_new(NULL);

#ifdef WITH_STATIC_SHOUTCAST
  g_string_append(string, _("\nThe SHOUTcast plugin has been built into streamtuner."));
#endif

  if (st_plugins_list)
    {
      g_string_append(string, _("\n<span weight=\"bold\">Loaded plugins:</span>\n"));

      SG_LIST_FOREACH(l, st_plugins_list)
	{
	  char *filename = l->data;
	  g_string_append_printf(string, "\n%s", filename);
	}
    }
  else
    g_string_append(string, _("\nThere are no loaded plugins."));
  
  if (st_handlers_list)
    {
      g_string_append(string, _("\n\n<span weight=\"bold\">Registered handlers:</span>\n"));
      
      SG_LIST_FOREACH(l, st_handlers_list)
	{
	  STHandler *handler = l->data;
	  g_string_append_printf(string, "\n%s", handler->label);
	  
	  if (handler->copyright)
	    g_string_append_printf(string, " - %s", handler->copyright);
	}
    }
  else
    g_string_append(string, _("\n\nThere are no registered handlers."));
      
  return g_string_free(string, FALSE);
}

GtkWidget *
st_about_dialog_new (GtkWindow *parent)
{
  STAboutDialog *dialog;

  dialog = g_object_new(ST_TYPE_ABOUT_DIALOG, NULL);

  if (parent)
    gtk_window_set_transient_for(GTK_WINDOW(dialog), parent);

  return GTK_WIDGET(dialog);
}
