/*
 * $Id: sgtk-alert-dialog.c,v 1.9 2004/01/05 19:44:09 jylefort Exp $
 *
 * Copyright (c) 2003 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <gtk/gtk.h>
#include "sgtk-hig.h"
#include "sgtk-alert-dialog.h"

/*** function declarations ***************************************************/

static void sgtk_alert_dialog_init (sGtkAlertDialog *dialog);

/*** implementation **********************************************************/

GType
sgtk_alert_dialog_get_type (void)
{
  static GType alert_dialog_type = 0;
  
  if (! alert_dialog_type)
    {
      static const GTypeInfo alert_dialog_info = {
	sizeof(sGtkAlertDialogClass),
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	sizeof(sGtkAlertDialog),
	0,
	(GInstanceInitFunc) sgtk_alert_dialog_init,
      };
      
      alert_dialog_type = g_type_register_static(SGTK_TYPE_DIALOG,
						 "sGtkAlertDialog",
						 &alert_dialog_info,
						 0);
    }

  return alert_dialog_type;
}

static void
sgtk_alert_dialog_init (sGtkAlertDialog *dialog)
{
  int action_area_border;

  gtk_widget_style_get(GTK_WIDGET(dialog),
		       "action-area-border", &action_area_border,
		       NULL);

  gtk_window_set_title(GTK_WINDOW(dialog), "");
  gtk_window_set_resizable(GTK_WINDOW(dialog), FALSE);
  gtk_box_set_spacing(GTK_BOX(GTK_DIALOG(dialog)->vbox), (SGTK_HIG_DIALOG_CONTENTS_SPACING * 2) - action_area_border - action_area_border);

  dialog->image = gtk_image_new();
  gtk_misc_set_alignment(GTK_MISC(dialog->image),
			 SGTK_HIG_ALERT_IMAGE_X_ALIGN,
			 SGTK_HIG_ALERT_IMAGE_Y_ALIGN);

  dialog->hbox = gtk_hbox_new(FALSE, SGTK_HIG_DIALOG_CONTENTS_SPACING);

  gtk_box_pack_start(GTK_BOX(dialog->hbox), dialog->image, FALSE, FALSE, 0);
  gtk_container_add(GTK_CONTAINER(SGTK_DIALOG(dialog)->contents), dialog->hbox);

  gtk_widget_show(dialog->image);
  gtk_widget_show(dialog->hbox);
}
