/*
 * $Id: sg-printable.h,v 1.6 2004/01/05 19:44:09 jylefort Exp $
 *
 * Copyright (c) 2003 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _SG_PRINTABLE_H
#define _SG_PRINTABLE_H

#include <glib.h>
#include <glib-object.h>
#include <stdarg.h>

#define SG_TYPE_PRINTABLE            (sg_printable_get_type ())
#define SG_PRINTABLE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SG_TYPE_PRINTABLE, SGPrintable))
#define SG_PRINTABLE_CLASS(obj)      (G_TYPE_CHECK_CLASS_CAST ((obj), SG_TYPE_PRINTABLE, SGPrintableIface))
#define SG_IS_PRINTABLE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SG_TYPE_PRINTABLE))
#define SG_PRINTABLE_GET_IFACE(obj)  (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SG_TYPE_PRINTABLE, SGPrintableIface))

typedef struct _SGPrintable SGPrintable; /* dummy typedef */

typedef struct
{
  GTypeInterface	interface;

  void (* print)	(SGPrintable *printable, const char *str);
} SGPrintableIface;

GType	sg_printable_get_type	(void);

void	sg_printable_print	(SGPrintable	*printable,
				 const char	*str);
void	sg_printable_printf	(SGPrintable	*printable,
				 const char	*format,
				 ...);

#endif /* _SG_PRINTABLE_H */
