# $Id: curl.m4,v 1.6 2004/01/31 14:51:35 jylefort Exp $
#
# This file is part of streamtuner.
#
# Copyright (c) 2002, 2003 Jean-Yves Lefort.
#
# As a special exception to the streamtuner licensing terms, Jean-Yves
# Lefort gives unlimited permission to copy, distribute and modify
# this file.

dnl AM_PATH_CURL([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
dnl
AC_DEFUN(AM_PATH_CURL,
[AC_PATH_PROG(CURL_CONFIG, curl-config, no)

# curl-config has been introduced in version 7.7.2
AC_MSG_CHECKING([for libcurl - version >= 7.7.2])

if test "x$CURL_CONFIG" = xno; then
	CURL_VERSION=""
	CURL_CFLAGS=""
	CURL_LIBS=""

	AC_MSG_RESULT([no])
	ifelse([$2],, :, [$2])
else
	CURL_VERSION=`$CURL_CONFIG --version | sed "s/^libcurl //"`
	CURL_CFLAGS=`$CURL_CONFIG --cflags`
	CURL_LIBS=`$CURL_CONFIG --libs`

	AC_MSG_RESULT([yes (version $CURL_VERSION)])
	ifelse([$1],, :, [$1])
fi

AC_SUBST(CURL_VERSION)
AC_SUBST(CURL_CFLAGS)
AC_SUBST(CURL_LIBS)])
