-- Copyright (C) 2010-2011 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "dynamics"
require "automotive"
require "toon"
require "moretextures"
require "transforms"

-- Setup collision response.

if layout.scaling then
   dynamics.collision.track = function (a, b)
				 if a.iswheel or b.iswheel then
				    assert (a.iswheel)

				   -- print (a, b)

				    return 1, unpack (layout.scaling)
				 end
			      end
end

local L, S = 1e4, 300

return nature.atmosphere {
   size = {1024, 512},

   turbidity = 3,

   rayleigh = math.scale({6.95e-06, 1.18e-05, 2.44e-05}, 1),
   mie = 7e-5,

   sun = {1.74, math.pi/4},

   -- The environment.

   ground = toon.flat {
      color = textures.periodic (textures.checkerboard (512, 512, 2)),

      surface = meshes.static {
	 size = {4, 6},
	 vertices = {-(L / 2), -(L / 2), 0,  0, 0, 1,  -S, -S,
		     (L / 2), -(L / 2), 0,  0, 0, 1,  S, -S,
		     (L / 2), (L / 2), 0,  0, 0, 1,  S, S,
		     -(L / 2), (L / 2), 0,  0, 0, 1,  -S, S},

	 indices = {0, 1, 2, 0, 2, 3}
      } (),

      environment = bodies.environment {
	 bodies.plane {
	 },

	 automotive.racetrack {
	    position = {-(L / 2), 0, 0},
	    orientation = transforms.euler (0, 0, 0),
	    
	    istrack = true,

	    scale = {10, 10},
      
	    [1] = {L, (L / 2), (L / 2), 0, 0, 0},
	 }
      },
   },
}
