-- Copyright (C) 2010-2011 Papavasileiou Dimitris                           
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local tracks = {
   {
      "/road/plane/1", "slipstream/tracks/plane-default.lua",
      "Default configuration",
   },

   {
      "/road/plane/2", "slipstream/tracks/plane-lowtraction.lua",
      "Lower traction variation",
   },

   {
      "/road/plane/3", "slipstream/tracks/plane-hightraction.lua",
      "Higher traction variation",
   },

   {
      "/road/laguna/1", "slipstream/tracks/laguna-default.lua",
      "Default configuration", 
   },

   {
      "/road/laguna/2", "slipstream/tracks/laguna-lowtraction.lua",
      "Lower traction variation",
   },

   {
      "/road/laguna/3", "slipstream/tracks/laguna-hightraction.lua",
      "Higher traction variation",
   },
}

for i = 1, #tracks do
   local url = '/slipstream/tracks' .. tracks[i][1]
   configurations.stock[url] = tracks[i][3]

   network.mime[url] = "text/html"
   network.pages[url] = string.format ([[
<?lua
resources.dofile ("%s")
?>

<head></head>
<body onload="javascript:window.location = '/slipstream/sessions/start';"></body>
]], tracks[i][2])
end