<?lua
-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
?>

<head>
  <title>Settings</title>
  <link rel="stylesheet" href="/stylesheet" type="text/css">
</head>

<body>
  <?lua return fragments.logo ?>
  <?lua return fragments.slipstreamnavigation ?>

  <?lua
   return fragments.processconfiguration {prefix = "/slipstream",
					  redirect = "/slipstream"}
  ?>

  <p>You can configure general settings that apply to the whole system
  here.</p>

  <?lua
    return fragments.beginconfiguration {onsave = "/slipstream",
					 onapply = "/slipstream/settings"}
  ?>

  <script type="text/javascript">
     function fullscreen()
     {
	var window;

	window = document.getElementsByName("graphics.window");
	window[0].value = <?lua return tostring(configuration.screen[1]) ?>;
	window[1].value = <?lua return tostring(configuration.screen[2]) ?>;
     }
  </script>

  <table class="configuration">
    <tr><th colspan="2">Graphics</th></tr>
    <tr><td>Window size</td>
        <td><input type="text"
                   name="graphics.window"
	           value="<?lua return string.format ("%d", graphics.window[1]) ?>" /> by 
            <input type="text"
                   name="graphics.window"
	           value="<?lua return string.format ("%d", graphics.window[2]) ?>" /> pixels.  Click <a href="javascript: fullscreen()">here</a> to make it fullscreen.
    </td></tr>

    <tr><td>Field of view</td>
        <td><input type="text"
                   name="derived.field"
	           value="<?lua return string.format ("%d", derived.field) ?>" /> &deg;
    </td></tr>

    <tr><td>Options</td>
        <td><p>These are mostly meant for troubleshooting graphics
        problems.  Try enabling them one at a time if you're having
        trouble getting the graphics to show up correctly.</p>

        <input type="checkbox"
                   name="options.framerate"
	           value="true"
                   <?lua return options.framerate and "checked" ?> /> Display framerate.

        <br/><input type="checkbox"
                   name="options.toon"
	           value="true"
                   <?lua return options.toon and "checked" ?> /> Use simple shading.

        <br/><input type="checkbox"
                   name="options.noarrays"
	           value="true"
                   <?lua return options.noarrays and "checked" ?> /> Don't use vertex arrays.

        <br/><input type="checkbox"
                   name="options.nobufferobjects"
	           value="true"
                   <?lua return options.nobufferobjects and "checked" ?> /> Don't use vertex buffer objects.

        <br/><input type="checkbox"
                   name="options.poweroftwo"
	           value="true"
                   <?lua return options.poweroftwo and "checked" ?> /> Scale textures so that their dimensions are powers of two.<br/>
    </td></tr>
  </table>
  <table class="configuration">
    <tr><th colspan="2">Audio</th></tr>
    <tr><td>Master volume</td>
        <td><input pre = "$ * 100"
                   post = "$ / 100"
                   type="text"
                   name="accoustics.gain"
	           value="<?lua return string.format ("%d", accoustics.gain) ?>" /> %
    </td></tr>
  </table>
  <hr/>
  <?lua return fragments.endconfiguration {apply = true, default = true} ?>
  <hr/>
</body>
