-- Copyright (C) 2010-2011 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "pages"
resources.dofile "slipstream/fragments.lua"

network.mime["/stylesheet"] = "text/css"
network.pages["/stylesheet"] = resources.readfile "slipstream/pages/stylesheet.lua"

network.mime['/slipstream'] = "text/html"
network.pages['/slipstream'] = resources.readfile "slipstream/pages/home.lua"

network.mime['/slipstream/logo'] = "image/svg+xml"
network.pages['/slipstream/logo'] = resources.readfile "slipstream/pages/logo.svg"

network.mime['/slipstream/sessions'] = "text/html"
network.pages['/slipstream/sessions'] = resources.readfile "slipstream/pages/sessions.lua"

network.mime['/slipstream/settings'] = "text/html"
network.pages['/slipstream/settings'] = resources.readfile "slipstream/pages/settings.lua"

network.mime['/slipstream/sessions/current'] = "text/html"
network.pages['/slipstream/sessions/current'] = resources.readfile "slipstream/pages/current.lua"

network.mime['/slipstream/sessions/wait'] = "text/html"
network.pages['/slipstream/sessions/wait'] = resources.readfile "slipstream/pages/wait.lua"

network.mime['/slipstream/sessions/export'] = "application/x-lua"
network.pages['/slipstream/sessions/export'] = [[
<?lua
local export = {}

-- Prepare the session for exporting.

if session.recorded then
   export.description = session.description
   export.comments = session.comments
else
   export.description = query.description
   export.comments = query.comments
end

export.channels = session.channels

-- Now serialize it.

return string.format("return %s,%s,%s",
		     string.serialize (blueprint),
		     string.serialize (layout),
		     string.serialize (export))
?>
]]

network.mime['/slipstream/sessions/import'] = "text/html"
network.pages['/slipstream/sessions/import'] = [=[
<?lua
if #query.script[1] > 0 then
   blueprint, layout, session = assert(loadstring(query.script[3]))()
end
?>

<html>
  <head>
  </head>
  <body onLoad="javascript: document.import.submit()">
  <form name="import" method="post"
        action="/slipstream/sessions/current">
    <input type="hidden" name="import"
	   value="<?lua return tostring(#query.script[1] > 0)?>" />
  </body>
</html>
]=]

network.mime['/slipstream/quit'] = "text/html"
network.pages['/slipstream/quit'] = [[
<?lua
common.iterate = false
network.block = false

return [=[<html>
  <head>
  </head>
  <body>
    <h1>Bye!</h1>
  </body>
</html>
]=]
?>
]]

network.mime['/slipstream/sessions/start'] = "text/html"
network.pages['/slipstream/sessions/start'] = [[
<?lua
network.block = false
graphics.hide = false

graph.vehicle = resources.dofile("slipstream/" .. blueprint.model ..
				 "/model.lua") 
graph.track = resources.dofile ("slipstream/tracks/" ..
				layout.track .. ".lua")
?>

<head></head>
<body onload="javascript:window.location = '/slipstream/sessions/wait';"></body>
]]

network.mime['/slipstream/sessions/end'] = "text/html"
network.pages['/slipstream/sessions/end'] = [[
<?lua
session = {}
?>

<head></head>
<body onload="javascript:window.location = '/slipstream';"></body>
]]

network.mime['/slipstream/sessions/restart'] = "text/html"
network.pages['/slipstream/sessions/restart'] = [[
<?lua
session = {}
?>
 
<head></head>
<body onload="javascript:window.location = '/slipstream/sessions/start';"></body>
]]

network.mime['/slipstream/sessions/inprogress'] = "text/plain"
network.pages['/slipstream/sessions/inprogress'] =
   function (method, url, version)
      if network.block then
	 return "Nope."
      end
   end

network.mime['/slipstream/configurations/export'] = "application/x-lua"
network.pages['/slipstream/configurations/export'] = [[
<?lua
script = ""

for key, value in pairs(query) do
   -- All query keys beginning with blueprint
   -- are assumed to be variables to set.

   if string.match (key, "^blueprint") then
      if type(value) == "table" then
	 value = "{" .. table.concat (value, ", ") .. "}"
      end

      script = script .. "   " .. key .. " = " .. value .. "\n"
   end
end

return script
?>
]]

-- Load the motorcycle-related pages.

network.mime['/motorcycle'] = "text/html"
network.pages['/motorcycle'] = resources.readfile "slipstream/motorcycle/home.lua"

network.mime['/motorcycle/engine'] = "text/html"
network.pages['/motorcycle/engine'] = resources.readfile "slipstream/motorcycle/engine.lua"

network.mime['/motorcycle/tyre'] = "text/html"
network.pages['/motorcycle/tyre'] = resources.readfile "slipstream/motorcycle/tyre.lua"

network.mime['/motorcycle/vehicle'] = "text/html"
network.pages['/motorcycle/vehicle'] = resources.readfile "slipstream/motorcycle/vehicle.lua"

network.mime['/motorcycle/control'] = "text/html"
network.pages['/motorcycle/control'] = resources.readfile "slipstream/motorcycle/control.lua"
