<!--
Copyright (C) 2008 Papavasileiou Dimitris                             
                                                                     
This program is free software: you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation, either version 3 of the License, or    
(at your option) any later version.                                  
                                                                     
This program is distributed in the hope that it will be useful,      
but WITHOUT ANY WARRANTY; without even the implied warranty of       
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
GNU General Public License for more details.                         
                                                                     
You should have received a copy of the GNU General Public License    
along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->

<head>
  <title>Motorcycle</title>
  <link rel="stylesheet" href="/stylesheet" type="text/css">
</head>

<body>
  <?lua return fragments.logo ?>
  <?lua return fragments.motorcyclenavigation ?>

  <?lua
     return fragments.processconfiguration {model = "motorcycle",
					    prefix = "/motorcycle",
					    redirect = "/motorcycle"}
  ?>

  <?lua
     return fragments.processimport
  ?>

  <p> The model is split up in sections which can be configured
  separately using the links in the tables below.</p> 
  
  <p>It is possible to export all or part of a vehicle configuration to a file by following the links on the bottom of each of these pages.  You can the select such a configuration file
      
  <?lua
     return fragments.importconfiguration {action = "/motorcycle"}
  ?>

  <p>You can also save the configuration of the whole model by filling
  in a description in the textbox at the bottom of the page and
  following the link before it.</p>

  <div class="section">Vehicle<span>[<a href="/motorcycle/vehicle">Edit</a>]</span></div>
  <?lua return fragments.presets {chunk = "vehicle",
				  action = "/motorcycle",
				  prefix = "/motorcycle/vehicle/"} ?>

  <div class="section">Engine<span>[<a href="/motorcycle/engine">Edit</a>]</span></div>
  <?lua return fragments.presets {chunk = "engine",
                                  action = "/motorcycle",
				  prefix = "/motorcycle/engine/"} ?>

  <div class="section">Front tyre<span>[<a href="/motorcycle/tyre?wheel=front">Edit</a>]</span></div>
  <?lua return fragments.presets {chunk = "fronttyre",
                                  action = "/motorcycle",
				  prefix = "/motorcycle/fronttyre/"} ?>

  <div class="section">Rear tyre<span>[<a href="/motorcycle/tyre?wheel=rear">Edit</a>]</span></div>
  <?lua return fragments.presets {chunk = "reartyre",
                                  action = "/motorcycle",
				  prefix = "/motorcycle/reartyre/"} ?>   

  <div class="section">Control<span>[<a href="/motorcycle/control">Edit</a>]</span></div>
  <?lua return fragments.presets {chunk = "control",
                                  action = "/motorcycle",
				  prefix = "/motorcycle/control/"} ?>   

  <?lua return fragments.beginconfiguration {onsave = "/slipstream",
					     chunk = "motorcycle"} ?>
  <?lua
     require "morestring"

     return string.format([[
    <input type=hidden name="blueprint" value='%s' />
]], string.serialize(blueprint))
   ?>
  <hr/>
  <?lua return fragments.endconfiguration{save = true, export = true} ?>
</body>
