-- Copyright (C) 2010-2011 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

-- These are the magic formula parameters for a 160/70 rear
-- motorcycle tyre.  Model is taken from:
--    Advances in the Modelling of Motorcycle Dynamics
--    R.S. SHARP, S. EVANGELOU and D.J.N. LIMEBEER

blueprint.rearresistance = 0.02
blueprint.rearradii = {0.297 - 0.08, 0.08}
blueprint.rearelasticity = {141e3, 1500}
blueprint.rearload = 1600
blueprint.rearxation = {9.694e-6, -1.333e-8, 1.898e-9}

blueprint.rearlongitudinal = {
      --              C_x     p_Dx1   p_Dx2      p_Ex1   p_Ex2
                      1.6064, 1.2017, -0.092206, 0.0263, 0.27056,
      --	      p_Ex3      p_Ex4   p_Kx1   p_Kx2    p_Kx3
   		      -0.076882, 1.1268, 25.939, -4.2327, 0.33686, 
      --              p_Bx1   p_Bx2   C_xalpha
   	              13.476, 11.354, 1.1231}
  	    
blueprint.rearlateral = {
      --         C_y      p_Dy1   p_Dy2     p_Dy3     p_Ey1     p_Ey2
                 0.93921, 1.1524, -0.01794,-0.065314, -0.94635, -0.098448,
      --         p_Ey4    p_Ky1   p_Ky2   p_Ky3   p_Ky4    p_Ky5 
		 -1.6416, 26.601, 1.0167, 1.4989, 0.52567, -0.24064,
      --         C_gamma  p_Ky6   p_Ky7 E_gamma
   	         0.50732, 0.7667, 0,    -4.7481,
      --         r_By1   r_By2   r_By3     C_ykappa
   	         7.7856, 8.1697, -0.0591138, 1.0533}
  
blueprint.rearmoment = {
      --        C_t     q_Bz1   q_Bz2   q_Bz5     q_Bz6     q_Bz9 
                1.3115, 10.354, 4.3004, -0.34033, -0.13202, 10.118,
      --        q_Bz10    q_Dz1    q_Dz2     q_Dz3     q_Dz4     q_Dz8
   	        -1.0508,  0.20059, 0.052816, -0.21116, -0.15941, 0.30941,
      --        q_Dz9    q_Dz10    q_Dz11    q_Ez1     q_Ez2   q_Ez3
     	            0,   0.10037,  0,        -3.9247,  10.809, -7.5785,
      --        q_Ez5   q_Hz3      q_Hz4
  	        0.9836, -0.049075, 0}
