-- Copyright (C) 2010-2011 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

-- These are the magic formula parameters for a 120/70 front
-- motorcycle tyre.  Model is taken from:
--    Advances in the Modelling of Motorcycle Dynamics
--    R.S. SHARP, S. EVANGELOU and D.J.N. LIMEBEER

blueprint.frontradii = {0.282 - 0.06, 0.06}
blueprint.frontelasticity = {130e3, 1500}
blueprint.frontresistance = 0.015
blueprint.frontload = 1100
blueprint.frontrelaxation = {8.633e-6, 3.725e-8, 8.389e-10}

blueprint.frontlongitudinal = {
      --              C_x     p_Dx1   p_Dx2      p_Ex1   p_Ex2
                      1.6064, 1.3806, -0.041429, 0.0263, 0.27056,
      --              p_Ex3      p_Ex4   p_Kx1   p_Kx2    p_Kx3
                      -0.076882, 1.1268, 25.939, -4.2327, 0.33686,
      --              p_Bx1   p_Bx2   C_xalpha
                      13.476, 11.354, 1.1231}

blueprint.frontlateral = {
      --         C_y      p_Dy1 p_Dy2 p_Dy3 p_Ey1    p_Ey2
                 0.83266, 1.3,  0,    0,    -1.2556, -3.2068,
      --         p_Ey4    p_Ky1   p_Ky2   p_Ky3   p_Ky4
                 -3.9975, 22.841, 2.1578, 2.5058, -0.08088,
      --         p_Ky5     C_gamma  p_Ky6    p_Ky7     E_gamma
                 -0.22882, 0.86765, 0.69677, -0.03077, -15.815,
      --         r_By1   r_By2   r_By3      C_ykappa
                 7.7856, 8.1697, -0.059138, 1.0533}

blueprint.frontmoment = {
      --        C_t     q_Bz1   q_Bz2       q_Bz5     q_Bz6
                1.0917, 10.486, -0.0011536, -0.68973, 1.0411,
      --        q_Bz9   q_Bz10   q_Dz1    q_Dz2     q_Dz3
                27.445, -1.0792, 0.19796, 0.065629, 0.2199,
      --        q_Dz4    q_Dz8   q_Dz9   q_Dz10   q_Dz11    q_Ez1     
                0.21866, 0.3682, 0.1218, 0.25439, -0.17873, -0.91586, 
      --        q_Ez2    q_Ez3       q_Ez5   q_Hz3       q_Hz4
                0.11625, -0.0024085, 1.4387, -0.0037886, -0.01557}
