-- Copyright (C) 2010-2011 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local tracks = {
   {"/road/plane", "slipstream/tracks/plane.lua",
    "A large flat track, good for test runs"},
   {"/road/laguna", "slipstream/tracks/laguna.lua",
    "A track based on Laguna Seca Raceway"}
}

for i = 1, #tracks do
   network.mime['/slipstream/tracks' .. tracks[i][1]] = "text/html"
   network.pages['/slipstream/tracks' .. tracks[i][1]] = string.format ([[
<?lua
graph.track = resources.dofile("%s")

network.block = false
graphics.hide = false
?>

<head></head>
<body onload="javascript:window.location = '/slipstream/wait';"></body>
]], tracks[i][2])

   configurations.stock['/slipstream/tracks' .. tracks[i][1]] = tracks[i][3]
end