<!--
Copyright (C) 2008 Papavasileiou Dimitris                             
                                                                     
This program is free software: you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation, either version 3 of the License, or    
(at your option) any later version.                                  
                                                                     
This program is distributed in the hope that it will be useful,      
but WITHOUT ANY WARRANTY; without even the implied warranty of       
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
GNU General Public License for more details.                         
                                                                     
You should have received a copy of the GNU General Public License    
along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->

<head>
  <title>Vehicle</title>
  <link rel="stylesheet" href="/stylesheet" type="text/css">
</head>

<body>
  <?lua return fragments.logo ?>
  <?lua return fragments.motorcyclenavigation ?>

  <?lua return fragments.processconfiguration {model = "motorcycle",
					       prefix = "/motorcycle",
					       redirect = "/motorcycle"}
   ?>
  
  <p> This page holds the specification of the chassis and suspension.
  You can see a schematic represantation of the geometry below.  Any
  changes made in the chassis geometry will, once applied, be updated
  on the diagram as well.  The wheelbase, fork offset and trails are
  calculated based on the chassis geomtry as specified in the Points
  section.  They can't be changed directly.</p>

  <img width="100%" src="/motorcycle/geometry" />

  <?lua
   -- Make a plot of the the motorcycle geometry.

   network.mime['/motorcycle/geometry'] = "image/svg+xml"
   network.pages['/motorcycle/geometry'] = function (method, uri, version)
      -- Return a figure of the motorcycle geometry.

      return plotting.cartesian {
	 size = {400 * 2.4 / 1.5, 400},
	 window = {-0.4, 2, -0.1, 1.4},
	 background = {1, 1, 1},
	 foreground = {0, 0, 0},

	 grid = true,
	 box = false,
	 axes = true,
	 ticks = true,
	 
	 labels = {"Longitudinal displacement (m)",
		   "Vertical displacement (m)",
		   ""},

	 fontscale = 3,

	 -- The wheels.

	 plotting.arc {
	    position = {blueprint.points[5][1], blueprint.points[5][3]},
	    radius = blueprint.points[5][3],
	 },
	 
	 plotting.arc {
	    position = {blueprint.points[6][1], blueprint.points[6][3]},
	    radius = blueprint.points[6][3],
	 },

	 -- The hinges.

	 plotting.symbols {
	    color = {1.0000, 0.3706, 0.0000},
	    symbol = 9,

	    {blueprint.points[5][1], blueprint.points[5][3]},
	    {blueprint.points[6][1], blueprint.points[6][3]},
	    {blueprint.points[10][1], blueprint.points[10][3]},
	    {blueprint.points[11][1], blueprint.points[11][3]},
	    {blueprint.points[13][1], blueprint.points[13][3]},
	    {blueprint.points[14][1], blueprint.points[14][3]},
	    {blueprint.points[15][1], blueprint.points[15][3]},
	    {blueprint.points[16][1], blueprint.points[16][3]},
	    {blueprint.points[17][1], blueprint.points[17][3]},
	    {blueprint.points[2][1], blueprint.points[2][3]},
	    {blueprint.points[8][1], blueprint.points[8][3]},
	 },

	 -- The main frame.

	 plotting.polygon {
	    color = {0, 0, 0},
	    style = 4,

	    {blueprint.points[11][1], blueprint.points[11][3]},
	    {blueprint.points[10][1], blueprint.points[10][3]},
	    {blueprint.points[13][1], blueprint.points[13][3]},
	    {blueprint.points[2][1], blueprint.points[2][3]},
	 },

	 plotting.line {
	    {blueprint.points[11][1], blueprint.points[11][3]},
	    {blueprint.points[10][1], blueprint.points[10][3]},
	    {blueprint.points[13][1], blueprint.points[13][3]},
	    {blueprint.points[2][1], blueprint.points[2][3]},
	    {blueprint.points[11][1], blueprint.points[11][3]},
	 },

	 -- The swingarm.

	 plotting.polygon {
	    style = 4,

	    {blueprint.points[6][1], blueprint.points[6][3]},
	    {blueprint.points[10][1], blueprint.points[10][3]},
	    {blueprint.points[16][1], blueprint.points[16][3]},
	 },

	 plotting.line {
	    {blueprint.points[6][1], blueprint.points[6][3]},
	    {blueprint.points[10][1], blueprint.points[10][3]},
	    {blueprint.points[16][1], blueprint.points[16][3]},
	    {blueprint.points[6][1], blueprint.points[6][3]},
	 },

	 -- Linkages.

	 plotting.line {
	    color = {0.0811, 0.3330, 0.3394},
	    width = 1.5,

	    {blueprint.points[16][1], blueprint.points[16][3]},
	    {blueprint.points[14][1], blueprint.points[14][3]},

	    {blueprint.points[14][1], blueprint.points[14][3]},
	    {blueprint.points[13][1], blueprint.points[13][3]},

	    {blueprint.points[14][1], blueprint.points[14][3]},
	    {blueprint.points[15][1], blueprint.points[15][3]},
	 },

	 -- The rear suspension.

	 plotting.line {
	    width = 3,

	    {blueprint.points[11][1], blueprint.points[11][3]},
	    {blueprint.points[15][1], blueprint.points[15][3]},
	 },

	 plotting.line {
	    width = 7,

	    {blueprint.points[11][1] - 
	     (blueprint.points[11][1] - blueprint.points[15][1]) * 0.15,
	  blueprint.points[11][3] -
	     (blueprint.points[11][3] - blueprint.points[15][3]) * 0.15},
	    {blueprint.points[15][1] +
	     (blueprint.points[11][1] - blueprint.points[15][1]) * 0.15,
	  blueprint.points[15][3] +
	     (blueprint.points[11][3] - blueprint.points[15][3]) * 0.15},
	 },

	 plotting.line {
	    width = 3,

	    {blueprint.points[3][1], blueprint.points[3][3]},
	    {blueprint.points[4][1], blueprint.points[4][3]},
	 },

	 plotting.line {
	    width = 7,

	    {blueprint.points[3][1] - 
	     (blueprint.points[3][1] - blueprint.points[4][1]) * 0.15,
	  blueprint.points[3][3] -
	     (blueprint.points[3][3] - blueprint.points[4][3]) * 0.15},
	    {blueprint.points[4][1] +
	     (blueprint.points[3][1] - blueprint.points[4][1]) * 0.15,
	  blueprint.points[4][3] +
	     (blueprint.points[3][3] - blueprint.points[4][3]) * 0.15},
	 },

	 -- The masses.

	 plotting.symbols {
	    color = {1, 0, 0},
	    symbol = 2,

	    {blueprint.points[3][1], blueprint.points[3][3]},
	    {blueprint.points[4][1], blueprint.points[4][3]},
	    {blueprint.points[12][1], blueprint.points[12][3]},
	    {blueprint.points[7][1], blueprint.points[7][3]},
	    {blueprint.points[9][1], blueprint.points[9][3]},
	 },

	 -- The axes.

	 plotting.lines {
	    color = {0.4122, 0.8667, 0.0242},
	    style = 4,

	    {blueprint.points[2][1] - 0.7 * math.cos(blueprint.headangle),
	     blueprint.points[2][3] - 0.7 * math.sin(blueprint.headangle)},
	    {blueprint.points[2][1] + 0.2 * math.cos(blueprint.headangle),
	     blueprint.points[2][3] + 0.2 * math.sin(blueprint.headangle)},

	    {blueprint.points[2][1] + 1.1 * math.sin(blueprint.headangle),
	     blueprint.points[2][3] - 1.1 * math.cos(blueprint.headangle)},
	    {blueprint.points[2][1] - 0.2 * math.sin(blueprint.headangle),
	     blueprint.points[2][3] + 0.2 * math.cos(blueprint.headangle)},

	    {blueprint.points[8][1] - 0.1, blueprint.points[8][3]},
	    {blueprint.points[8][1] + 0.1, blueprint.points[8][3]},

	    {blueprint.points[8][1], blueprint.points[8][3] - 0.1},
	    {blueprint.points[8][1], blueprint.points[8][3] + 0.3},
	 },

	 -- The rider.

	 plotting.symbols {
	    color = {0, 0, 0},
	    symbol = 27,

	    {blueprint.points[9][1], blueprint.points[9][3]},
	 },

	 plotting.lines {
	    {blueprint.points[8][1], blueprint.points[8][3]},
	    {blueprint.points[9][1], blueprint.points[9][3]},
	 },

	 -- The aerodynamic reference point.

	 plotting.symbols {
	    color = {0, 0, 0},
	    symbol = 5,

	    {blueprint.points[1][1], blueprint.points[1][3]},
	 },

	 -- The labels.

	 plotting.label {
	    color = {0.15, 0.15, 0.2},
	    justification = 0.5,
	    position = {blueprint.points[1][1],
			blueprint.points[1][3] + 0.06},
	    text = "p#d1",
	 },

	 plotting.label {
	    position = {blueprint.points[2][1] + 0.03,
			blueprint.points[2][3] - 0.01},
	    text = "p#d2",
	 },

	 plotting.label {
	    position = {blueprint.points[3][1] + 0.02,
			blueprint.points[3][3] + 0.03},
	    text = "p#d3",
	 },

	 plotting.label {
	    position = {blueprint.points[4][1] + 0.02,
			blueprint.points[4][3] + 0.04},
	    text = "p#d4",
	 },

	 plotting.label {
	    justification = 0.5,
	    position = {blueprint.points[5][1],
			blueprint.points[5][3] - 0.04},
	    text = "p#d5",
	 },

	 plotting.label {
	    justification = 0.5,
	    position = {blueprint.points[6][1],
			blueprint.points[6][3] - 0.04},
	    text = "p#d6",
	 },

	 plotting.label {
	    position = {blueprint.points[7][1] + 0.03,
			blueprint.points[7][3]},
	    text = "p#d7",
	 },

	 plotting.label {
	    position = {blueprint.points[8][1] + 0.03,
			blueprint.points[8][3] - 0.03},
	    text = "p#d8",
	 },

	 plotting.label {
	    position = {blueprint.points[9][1] + 0.02,
			blueprint.points[9][3]},
	    text = "p#d9",
	 },

	 plotting.label {
	    justification = 0.5,
	    position = {blueprint.points[10][1],
			blueprint.points[10][3] - 0.03},
	    text = "p#d10",
	 },

	 plotting.label {
	    justification = 1,
	    position = {blueprint.points[11][1] - 0.03,
			blueprint.points[11][3]},
	    text = "p#d11",
	 },

	 plotting.label {
	    justification = 0.5,
	    position = {blueprint.points[12][1],
			blueprint.points[12][3] - 0.03},
	    text = "p#d12",
	 },

	 plotting.label {
	    position = {blueprint.points[13][1] + 0.03,
			blueprint.points[13][3]},
	    text = "p#d13",
	 },

	 plotting.label {
	    justification = 0.5,
	    position = {blueprint.points[14][1],
			blueprint.points[14][3] - 0.03},
	    text = "p#d14",
	 },

	 plotting.label {
	    justification = 1,
	    position = {blueprint.points[15][1] - 0.03,
			blueprint.points[15][3]},
	    text = "p#d15",
	 },

	 plotting.label {
	    justification = 0.5,
	    position = {blueprint.points[16][1],
			blueprint.points[16][3] + 0.06},
	    text = "p#d16",
	 },

	 plotting.label {
	    position = {blueprint.points[17][1] + 0.03,
			blueprint.points[17][3]},
	    text = "p#d17",
	 },
      }
   end
  ?>

  <?lua
    return fragments.beginconfiguration {onapply = "/motorcycle/vehicle",
					 onsave = "/motorcycle",
					 chunk = "vehicle"}
   ?>

  <?lua return fragments.postprocessor[[
     var x, m, Ixx, Iyy, Izz, Ixy, Ixz, Iyz;

     // Gather point component.

     x = document.getElementsByClassName ("coordinate");
     hidden = document.getElementsByName ("blueprint.points");

     for (i = 0 ; i < hidden.length ; i += 1) {
	hidden[i].value = "{" + x[2 * i].value + ", 0, " + 
	   x[2 * i + 1].value + "}";
     }

     // Gather mass components.

     m = document.getElementsByClassName ("m");
     Ixx = document.getElementsByClassName ("Ixx");
     Ixy = document.getElementsByClassName ("Ixy");
     Ixz = document.getElementsByClassName ("Ixz");
     Iyy = document.getElementsByClassName ("Iyy");
     Iyz = document.getElementsByClassName ("Iyz");
     Izz = document.getElementsByClassName ("Izz");
     hidden = document.getElementsByName ("blueprint.masses");

     for (i = 0 ; i < hidden.length ; i += 1) {
	hidden[i].value = "{" + m[i].value + ", " + 
	   Ixx[i].value + ", " + Iyy[i].value + ", " + 
	   Izz[i].value + ", " + Ixy[i].value + ", " + 
	   Ixz[i].value + ", " + Iyz[i].value + "}";
     }
  ]] ?>

  <table class="configuration">
    <tr><th colspan="2">General</th></tr>
    <tr><td>Chassis torsional compliance</td>
        <td><input type="text"
                   name="blueprint.chassisstiffness"
	           value="<?lua return string.format ("%g", blueprint.chassisstiffness) ?>" />
           <table class="fraction">
             <tr><td>Nm</td></tr>
	     <tr><td>rad</td></tr>
           </table> stiffness 
           and <input type="text"
                   name="blueprint.chassisdamping"
	           value="<?lua return string.format ("%g", blueprint.chassisdamping) ?>" />
           <table class="fraction">
             <tr><td>Nms</td></tr>
	     <tr><td>rad</td></tr>
           </table> damping.
        </td>
    </tr>
    <tr><td>Steering geometry</td>
        <td><input pre = "Math.round($ / Math.PI * 180 * 10) / 10"
                   post = "$ / 180 * Math.PI"
                   type="text"
                   name="blueprint.headangle"
	           value="<?lua return string.format ("%g", blueprint.headangle) ?>" /> &deg head angle with a travel of
            <input pre = "Math.round($ / Math.PI * 180 * 10) / 10"
                   post = "$ / 180 * Math.PI"
                   type="text"
                   name="blueprint.steeringtravel"
	           value="<?lua return string.format ("%g", blueprint.steeringtravel) ?>" /> &deg.</td>
    </tr>
    <tr><td>Steering damping</td>
        <td><input type="text"
                   name="blueprint.steeringdamping"
	           value="<?lua return string.format ("%g", blueprint.steeringdamping) ?>" />
           <table class="fraction">
             <tr><td>Nms</td></tr>
	     <tr><td>rad</td></tr>
           </table>
        </td>
    </tr>
    <tr><td>Wheelbase</td><td><?lua
     return string.format ("%d", math.abs(blueprint.points[5][1] -
					  blueprint.points[6][1]) * 1e3)
     ?> mm</td></tr>
    <?lua
     local html
     local v, p, q, u, d

     v = {-math.sin(blueprint.headangle),
		math.cos(blueprint.headangle)}
     p = {blueprint.points[2][1], blueprint.points[2][3]}
     
     -- Calculate fork offset (distance of front wheel
     -- joint to steering axis)

     q = {blueprint.points[5][1], blueprint.points[5][3]}
     u = math.dot (math.subtract(q, p), v)
     d = math.distance (q, math.add(p, math.scale(v, u)))

     html = string.format ([[
      <tr><td>Fork offset</td><td>%d mm</td></tr>
      <tr><td>Trail</td><td>%d mm</td></tr>
]], d * 1e3, (-q[2] * v[1] - d) / v[2] * 1e3)

     -- Calculate mechanical trail (distance of front wheel
     -- contact point to steering axis)

     local q = {blueprint.points[5][1], 0}

     local u = math.dot (math.subtract(q, p), v)
     local d = math.distance (q, math.add(p, math.scale(v, u)))

     html = html .. string.format ([[
      <tr><td>Mechanical trail</td><td>%d mm</td></tr>
]], d * 1e3)

     return html
     ?>
    </tr>
  </table>
  <table class="configuration">
    <tr><th>Points</th><th>x</th><th>z</th></tr>
    <?lua
       local html = ""
       local labels = {
	  "Aerodynamic reference point",
	  "Twist axis joint with main frame",
	  "Centre of mass of front frame steer body",
	  "Centre of mass of front frame suspension body",
	  "Front wheel attachment point",
	  "Rear wheel attachment point",
	  "Centre of mass of the main frame",
	  "Attachment point for rider on main frame",
	  "Rider centre of mass",
	  "Point of attachment for swinging arm onto main frame",
	  "Attachment point for the rear spring onto main frame",
	  "Centre of mass of swinging arm",
	  "Swinging link pivot for monoshock suspension",
	  "Lower connecting link pivot for monoshock suspension",
	  "Spring / link attachment for monoshock suspension",
	  "Upper connecting link pivot for monoshock suspension",
	  "Engine output shaft",
       }

       for i = 1, #blueprint.points do
	  html = html .. string.format([[
    <input type="hidden" name="blueprint.points" />
    <tr><td>%s</td>
        <td><input type="text" class="coordinate" value="%g" /></td>
        <td><input type="text" class="coordinate" value="%g" /> m</td>
    </tr>
]], labels[i], blueprint.points[i][1], blueprint.points[i][3])
       end

       return html
     ?>

    </tr>
  </table>
  <table class="configuration">
	  <tr><th colspan="3">Mass and inertia</th></tr>
    <?lua
       local html = ""
       local labels = {
	  "Front frame (Steering head assembly)",
	  "Front suspension unsprung mass",
	  "Main frame (including rider lower body)",
	  "Rider upper body",
	  "Rear frame (Swingarm)",
	  "Front wheel",
	  "Rear wheel",
       }

       for i = 1, #blueprint.masses do
	  html = html .. string.format([[
    <input type="hidden" name="blueprint.masses" />
    <tr><td>%s</td>
        <td style="white-space: nowrap;"><input type="text" class="m" value="%g" /> kg </td>
        <td style="white-space: nowrap;">
          <table class="matrix">
            <tr>
              <td rowspan="4"/>
              <td><input type="text" class="Ixx" value="%g" /></td>
              <td/>
              <td/>
              <td rowspan="4"/>
            </tr>
            <tr>
              <td><input type="text" class="Ixy" value="%g" /></td>
              <td><input type="text" class="Iyy" value="%g" /></td>
              <td/></tr>
            <tr>
              <td><input type="text" class="Ixz" value="%g" /></td>
              <td><input type="text" class="Iyz" value="%g" /></td>
              <td><input type="text" class="Izz" value="%g" /></td>
            </tr>
          </table> kg m<sup>2</sup></td>
        </tr>
]], labels[i], blueprint.masses[i][1],
               blueprint.masses[i][2], blueprint.masses[i][5],
               blueprint.masses[i][3], blueprint.masses[i][6],
               blueprint.masses[i][7], blueprint.masses[i][4])
       end

       return html
     ?>
  </table>
  <table class="configuration">
    <tr><th colspan="2">Front suspension</th></tr>
    <tr><td>Springing</td>
        <td>Stiffness of <input type="text"
                   name="blueprint.frontstiffness"
	           value="<?lua return string.format ("%g", blueprint.frontstiffness) ?>" />
	    <table class="fraction">
	      <tr><td>N</td></tr>
	      <tr><td>m</td></tr>
            </table> 
	    with <input pre="$ * 1e3"
                   post="$ / 1e3"
                   type="text"
                   name="blueprint.frontpreload"
	           value="<?lua return string.format ("%g", blueprint.frontpreload) ?>" /> mm preload
        </td>
    </tr>
    <tr><td>Damping</td>
        <td>
	    <input type="text"
                   name="blueprint.frontdamping"
	           value="<?lua return string.format ("%g", blueprint.frontdamping[1]) ?>" />
	    <table class="fraction">
	      <tr><td>Ns</td></tr>
	      <tr><td>m</td></tr>
            </table> at compression and
	    <input type="text"
                   name="blueprint.frontdamping"
	           value="<?lua return string.format ("%g", blueprint.frontdamping[2]) ?>" />
	    <table class="fraction">
	      <tr><td>Ns</td></tr>
	      <tr><td>m</td></tr>
            </table> at rebound.
	</td>
    </tr>
    <tr><td>Suspension travel</td>
        <td>
	    <input pre="$ * 1e3"
                   post="$ / 1e3"
                   type="text"
                   name="blueprint.frontlocks"
	           value="<?lua return string.format ("%g", blueprint.frontlocks[1]) ?>" /> mm to
	    <input pre="$ * 1e3"
                   post="$ / 1e3"
                   type="text"
                   name="blueprint.frontlocks"
	           value="<?lua return string.format ("%g", blueprint.frontlocks[2]) ?>" /> mm relative to trim state.
	</td>
    </tr>
  </table>
  <table class="configuration">
    <tr><th colspan="2">Rear suspension</th></tr>
    <tr><td>Springing</td>
        <td>Stiffness of <input type="text"
                   name="blueprint.rearstiffness"
	           value="<?lua return string.format ("%g", blueprint.rearstiffness) ?>" />
	    <table class="fraction">
	      <tr><td>N</td></tr>
	      <tr><td>m</td></tr>
            </table> 
            with <input pre="$ * 1e3"
                   post="$ / 1e3"
                   type="text"
                   name="blueprint.rearpreload"
	           value="<?lua return string.format ("%g", blueprint.rearpreload) ?>" /> mm of preload.
        </td>
    </tr>
    <tr><td>Damping</td>
        <td>
	    <input type="text"
                   name="blueprint.reardamping"
	           value="<?lua return string.format ("%g", blueprint.reardamping[1]) ?>" />
	    <table class="fraction">
	      <tr><td>Ns</td></tr>
	      <tr><td>m</td></tr>
            </table> at compression and
	    <input type="text"
                   name="blueprint.reardamping"
	           value="<?lua return string.format ("%g", blueprint.reardamping[2]) ?>" />
	    <table class="fraction">
	      <tr><td>Ns</td></tr>
	      <tr><td>m</td></tr>
            </table> at rebound
	</td>
    </tr>
    <tr><td>Suspension travel</td>
        <td>
	    <input pre="$ * 1e3"
                   post="$ / 1e3"
                   type="text"
                   name="blueprint.rearlocks"
	           value="<?lua return string.format ("%g", blueprint.rearlocks[1]) ?>" /> mm to
	    <input pre="$ * 1e3"
                   post="$ / 1e3"
                   type="text"
                   name="blueprint.rearlocks"
	           value="<?lua return string.format ("%g", blueprint.rearlocks[2]) ?>" /> mm relative to trim state.
	</td>
    </tr>
  </table>
  <table class="configuration">
    <tr><th colspan="2">Final drive</th></tr>
    <tr><td>Countershaft sprocket radius</td>
        <td><input pre="$ * 1e3"
                   post="$ / 1e3"
                   type="text"
                   name="blueprint.sprockets"
	           value="<?lua return string.format ("%g", blueprint.sprockets[1]) ?>" /> mm</td>
    </tr>
    <tr><td>Rear wheel sprocket radius</td>
        <td><input pre="$ * 1e3"
                   post="$ / 1e3"
                   type="text"
                   name="blueprint.sprockets"
	           value="<?lua return string.format ("%g", parts.drive.radii[2]) ?>" /> mm</td>
    </tr>
  </table>
  <table class="configuration">
    <tr><th colspan="2">Aerodynamics</th></tr>
    <tr><td>Coefficient of lift</td>
        <td><input type="text"
                   name="blueprint.lift"
	           value="<?lua return string.format ("%g", blueprint.lift) ?>" />
        </td>
    </tr>
    <tr><td>Coefficient of drag</td>
        <td><input type="text"
                   name="blueprint.drag"
	           value="<?lua return string.format ("%g", blueprint.drag) ?>" />
        </td>
    </tr>
    <tr><td>Coefficient of pitching moment</td>
        <td><input type="text"
                   name="blueprint.pitch"
	           value="<?lua return string.format ("%g", blueprint.pitch) ?>" />
        </td>
    </tr>
    <tr><td>Frontal area</td>
        <td><input type="text"
                   name="blueprint.area"
	           value="<?lua return string.format ("%g", blueprint.area) ?>" /> m<sup>2</sup>
        </td>
    </tr>
  </table>
  <hr/>
  <?lua return fragments.endconfiguration {apply = true, save = true} ?>
  <hr/>
</body>
