-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

fragments = {}

function fragments.tracks(context)
   return [=[
    <table class="presets">
    <tr><th colspan="3">Tracks</th></tr>
  <?lua
     local html = ""

     for key, tag in pairs(configurations.stock) do
        if string.match (key, "^]=] .. context.prefix .. [=[") then
	   html = html .. string.format ([[
      <tr><td>%s</td><td><a href="%s">race</a></td></tr>
]], tag, key)
	end
     end

     return html
   ?>
  ]=]
end

function fragments.presets(context)
   return [=[
  <form name="]=] .. context.chunk .. [=[_presets" action="]=] .. context.action .. [=[" method="post">
    <input type="hidden" name="remove" />
    <script type="text/javascript">
      function remove_]=] .. context.chunk .. [=[ (preset)
      {
	 var form;
	 
	 form = document.forms.]=] .. context.chunk .. [=[_presets;

	 form.remove.value = preset;
	 form.submit();
      }
    </script>

    <table class="presets">
    <tr><th colspan="3">Stock configurations</th></tr>
  <?lua
     local html = ""

     for key, tag in pairs(configurations.stock) do
        if string.match (key, "^]=] .. context.prefix .. [=[") then
	   html = html .. string.format ([[
      <tr><td>%s</td><td><a href="%s">load</a></td></tr>
]], tag, key)
	end
     end

     return html
   ?>

    <tr><th colspan="3">Custom configurations</th></tr>
  <?lua
     local html = ""

     if query.remove then
	configurations.pages[query.remove] = nil
	configurations.mime[query.remove] = nil
	configurations.custom[query.remove] = nil
     end

     -- TODO: fix this when Lua 5.2 arrives.
 
     for key, tag in getmetatable(configurations.custom).__pairs() do
        if string.match (key, "^]=] .. context.prefix .. [=[") then
	   html = html .. string.format ([[
      <tr><td>%s</td><td><a href="%s">load</a></td><td><a href="javascript:remove_]=] .. context.chunk .. [=[('%s')">remove</a></td></tr>
]], tag, key, key)
	end
     end

     if #html == 0 then
	html = [[
    <tr><td>No presets have been created yet</td><td/></tr>
]]
     end

     return html
   ?>
    </table>
  </form>
]=]
end

function fragments.preprocessor(script)
   return [=[
  <script type="text/javascript">
    preprocessors.push(function () {
]=] .. script .. [=[
    });
  </script>
]=]
end

function fragments.postprocessor(script)
   return [=[
  <script type="text/javascript">
    postprocessors.push(function () {
]=] .. script .. [=[
    });
  </script>
]=]
end

function fragments.beginconfiguration(context)
  local fragment = [=[
  <form name="configuration" method="post">
  <script type="text/javascript">
     var preprocessors = [function (form) {
        var i, form;

        for (i = 0;
	     i < form.elements.length;
	     i += 1) {
	   var element = form.elements[i];
	   var pre = element.getAttribute("pre");
	   
	   if (pre) {
	      element.value = eval(pre.replace ("$", element.value));
	   }
	}
     }]

     var postprocessors = [function (form) {
        var i, form;

        for (i = 0;
	     i < form.elements.length;
	     i += 1) {
	   var element = form.elements[i];
	   var post = element.getAttribute("post");

	   if (post) {
	      element.value = eval(post.replace ("$", element.value));
	   }
	}
     }]

     function submit(save)
     {
	var form, description, checks;

	form = document.forms.configuration;
	hidden = document.getElementById("save");

	// Deal with whether we want to save or not.

	if (save) {
	   description = document.getElementById("description");

	   if (description) {
	      hidden.value = description.value;
	   } else {
	      hidden.value = "true";
	   }

	   form.action="]=] .. (context.onsave or '') .. [=["
	} else {
	   hidden.value = "false";
	   form.action="]=] .. (context.onapply or '') .. [=["
	}

	// Make all checkboxes return false when
	// not checked.

	checks = form.getElementsByTagName("input");

	for (i in checks) {
	   var e = checks[i];

	   if (e.type == "checkbox") {
	      if (e.checked) {
		 e.value = "true";
	      } else {
	         e.value = "false";
		 e.checked = true;
	      }
	   }
	}

	// Postprocess and submit.

	for (i in postprocessors) {
	   postprocessors[i](form)
	}

	form.submit();
     }

    window.addEventListener("load", function () {
       var form;

       form = document.forms.configuration;

       for (i in preprocessors) {
	  preprocessors[i](form)
       }
    }, false);
  </script>
  
  <input type="hidden" id="save" name="save" />
]=]

   if context.chunk then
      fragment = fragment .. [=[
  <input type="hidden" name="chunk" value="]=] .. context.chunk .. [=[" />
]=]
   end

   return fragment
end

function fragments.endconfiguration(context)
   local fragment = [=[
  </form>
]=]
   if context.apply then
      fragment = fragment .. [=[
  <a href="javascript: submit(false)">Apply</a> this configuration for now only.
]=]

      if context.default or context.save then
         fragment = fragment .. [=[
   <br/>
]=]
      end
   end

   if context.save then
      fragment = fragment .. [=[
  <a href="javascript: submit(true)">Save</a> this configuration as
    <input type="text" id="description" class="description"
           value="<?lua return string.format('Configuration created on %s',
		    os.date('%a, %d %b %Y %T'))?>"/>.
]=]

      if context.default then
         fragment = fragment .. [=[
   <br/>
]=]
      end
   end

   if context.default then
      fragment = fragment .. [=[
  <a href="javascript: submit(true)">Save</a> this configuration.
]=]
   end

   return fragment
end

function fragments.processconfiguration(context)
   local fragment  = [=[
<?lua
local script, uri, full, html, file

if query.save == nil then
   return
end
 
script = ""

for key, value in pairs(query) do
   -- All query keys of the form foo.bar as well as blueprin
   -- are assumed to be variables to set.

   if key == "blueprint" or string.find (key, "%.") then
      if type(value) == "table" then
	 value = "{" .. table.concat (value, ", ") .. "}"
      end

      script = script .. "   " .. key .. " = " .. value .. "\n"
   end
end

html = [[
<table class="notification"><tr><td><ul>
]]
]=]

   -- If this is a model chunk configuration
   -- reload the model.

   if context.model then
      fragment = fragment .. [=[

script = script .. "graph.vehicle = resources.dofile 'slipstream/]=] .. context.model .. [=[/model.lua'"
]=]
   end
   
   fragment = fragment .. [=[
assert (loadstring (script))()

html = html .. [[
  <li>Your changes have been applied.</li>
]]
]=]

   if context.model then
      -- Save the model chunk using a bookmark.

      fragment = fragment .. [=[

if query.save and query.save ~= "false" then
   uri = string.format ("]=] .. context.prefix .. [=[/%s/%d", query.chunk, os.time())

   configurations.pages[uri] = [[
<?lua
]] .. script .. [[
?>

<head></head>
<body onload="javascript:window.location = ']=] .. context.redirect .. [=[';"></body>
]]

   configurations.mime[uri] = "text/html"
   configurations.custom[uri] = query.save

   html = html .. [[
  <li>Your changes have been saved as:<br/>]] .. query.save .. [[.</ul>
]]
end
]=]
   else
      -- Save global configuration into .rc file.

      fragment = fragment .. [=[

if query.save and query.save ~= "false" then
   file = io.open (os.getenv ("HOME") .. "/.slipstream", "w")

   if file then
      file:write ([[
-- These settings have been written by the graphical interface.
-- If you make any changes, keep in mind that they will be replaced
-- next time you click save in the settings page.

]])
      file:write (script)
      
      if query.save == "true" then
	 html = html .. [[
  <li>Your changes have been saved.</ul>
]]
      else
	 html = html .. [[
  <li>Your changes have been saved as:<br/>]] .. query.save .. [[.</ul>
]]
      end
   else

      html = html .. [[
  <li>Your changes could not be saved because I can't write to ']] .. os.getenv ("HOME") .. [[/.slipstream'.</ul>
]]
   end
end
]=]
   end

   fragment = fragment .. [=[

html = html .. [[
</ul></td></tr></table>
]]

return html
?>
]=]

   return fragment
end

-- print (fragments.processconfiguration {prefix = "/slipstream",
-- 				       redirect = "/slipstream"})
-- abort()

function fragments.editloadedmodel(context)
   return [=[
<?lua
  if network.pages['/]=] .. context.model .. [=['] then
     return [[<span>[<a href="/]=] .. context.model .. [=[">Edit</a>]</span>]]
  end
 ?>
]=]
end

fragments.logo = [=[
<img id="logo" src="/slipstream/logo" />
]=]

fragments.slipstreamnavigation = [=[
<table class="navigation">
<tr><th>Slipstream</th><tr>
<tr><td>
  <a href="/slipstream">home</a>&nbsp;&middot;&nbsp;<a href="/slipstream/settings">settings</a>&nbsp;&middot;&nbsp;<a href="/slipstream/quit">quit</a>
</td></tr>
</table>
]=]

fragments.motorcyclenavigation = [=[
<table class="navigation-container">
<tr><td>
]=] .. fragments.slipstreamnavigation .. [=[
</td><td>
<table class="navigation">
<tr><th>Motorcycle</th><tr>
<tr><td>
<a href="/motorcycle">home</a>&nbsp;&middot;&nbsp;<a href="/motorcycle/vehicle">vehicle</a>&nbsp;&middot;&nbsp;<a href="/motorcycle/engine">engine</a>&nbsp;&middot;&nbsp;<a href="/motorcycle/tyre?wheel=front">front tyre</a>&nbsp;&middot;&nbsp;<a href="/motorcycle/tyre?wheel=rear">rear tyre</a>&nbsp;&middot;&nbsp;<a href="/motorcycle/control">control</a>
</td></tr>
</table>
</td></tr>
</table>
]=]