/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
#include <iostream>
using namespace std;

#include "../../constants.h"

void PreferencesDialog::audioDriverSelected( const QString & driver_name )
{
    if (driver_name == JACK_LABEL) {
        audioDriverBox->setCurrentText(JACK_LABEL);
	jackGroupBox->setEnabled(true);
	bufferSizeLabel->setEnabled(false);
	bufferSizeBox->setEnabled(false);
    } else {
	jackGroupBox->setEnabled(false);
	bufferSizeLabel->setEnabled(true);
	bufferSizeBox->setEnabled(true);
        if (driver_name == NULL_LABEL) {
            audioDriverBox->setCurrentText(NULL_LABEL);
        } else if (driver_name == LIBAO_LABEL) {
            audioDriverBox->setCurrentText(LIBAO_LABEL);
        }
    }
}


bool PreferencesDialog::getOpenLastSong()
{
    return openLastSongBox->isChecked();
}

void PreferencesDialog::setOpenLastSong(bool v)
{
    openLastSongBox->setChecked(v);
}

int PreferencesDialog::getAudioBufferSize()
{
    return bufferSizeBox->currentText().toInt();
}

void PreferencesDialog::setAudioBufferSize(int size) {
    bufferSizeBox->setCurrentText(QString("%1").arg(size));
}

QString PreferencesDialog::getAudioDriver()
{
    return audioDriverBox->currentText();
}

void PreferencesDialog::setAudioDriver( QString driver )
{
    audioDriverBox->setCurrentText(driver);
}

void PreferencesDialog::setJackAutoConnect( bool p )
{
   jackAutoConnectBox->setChecked(p);
}

bool PreferencesDialog::getJackAutoConnect()
{
   return jackAutoConnectBox->isChecked();
}

void PreferencesDialog::setJackMulti( bool p )
{
   jackTrackOutputsBox->setChecked(p);
}

bool PreferencesDialog::getJackMulti()
{
   return jackTrackOutputsBox->isChecked();
}


void PreferencesDialog::init()
{
#ifndef WITH_JACK
deleteDriver( JACK_LABEL);
#endif
#ifndef WITH_LIBAO
deleteDriver(LIBAO_LABEL);
#endif
 }

void PreferencesDialog::deleteDriver( const QString & label )
{
    for(int i = 0; i < audioDriverBox->count(); ++i) {
	if (audioDriverBox->text(i) == label) {
	    audioDriverBox->removeItem(i);
	}
    } 
}
