/*
 *   $Id: RowSet.h,v 1.4 2006/02/18 22:33:37 rhizome Exp $
 * 
 *      Copyright (C) 2004, 2005 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef ROW_SET_H
#define ROW_SET_H

#include <qwidget.h>
#include <qlayout.h>

class QVBoxLayout;
class Song;
class Channel;

class VBoxLayout : public QVBoxLayout {
public:
    VBoxLayout(QWidget* parent, int margin, int spacing) 
        : QVBoxLayout(parent, margin, spacing) {}
    inline void clear() { deleteAllItems(); }
};

class RowSet : public QWidget {
    Q_OBJECT
public:
    RowSet(QWidget*, Song*);
    virtual ~RowSet() {}
    void setSong(Song*);
    void populate();
    void clear();
    virtual void activate(QWidget*, Channel*) {}
public slots:
    void addChannel(Channel*);
    void deleteChannel(Channel*);
    void syncChannelPosition(Channel*);
protected:
    virtual QWidget* createRow(Channel*) = 0;
    QPtrList<QWidget> rows; 
    QMap<Channel*, QWidget*> chan_row_map;
    Song* song;
    VBoxLayout* layout;
};

#endif

//EOF 

