/*
 *   $Id: PadButton.h,v 1.3 2006/04/14 00:12:09 rhizome Exp $
 * 
 *      Copyright (C) 2004, 2005, 2006 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef PADBUTTON_H
#define PADBUTTON_H

#include <qbrush.h>
#include <qpen.h>
#include <qpushbutton.h>

class PadButton : public QPushButton {
    Q_OBJECT
    public:
        PadButton(QWidget* parent);
        void paintEvent (QPaintEvent *);
    public slots:
        void setVolume(int);
    private:
        QPen pen;
        QBrush brush;
        QPixmap createPixmap();
        void mouseMoveEvent (QMouseEvent*);
        void wheelEvent(QWheelEvent*);
        int volume_position;
    signals:
        void volumeChanged(int);
};

int volumePosition2Value(int);

#endif

//EOF
