/*
 *   $Id: PadButton.cpp,v 1.5 2006/04/14 11:45:54 rhizome Exp $
 * 
 *      Copyright (C) 2004, 2005, 2006 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <qpainter.h>
#include <qpixmapcache.h>

#include "PadButton.h"

PadButton::PadButton(QWidget* parent) 
    : QPushButton(parent), volume_position(0) { }

void PadButton::paintEvent(QPaintEvent*) {
    QString key;
    if (isEnabled()) {
        if (isOn()) {
            key = QString("PadButton:On:") + QString::number(volume_position);
        } else {
            key = QString("PadButton:Off:") + QString::number(volume_position);
        }
    } else {
        key = QString("PadButton:disabled");
    }
    QPixmap pixmap;
    if (not QPixmapCache::find(key, pixmap)) {
        pixmap = createPixmap();
        QPixmapCache::insert(key, pixmap);
    }
    bitBlt(this, 0, 0, &pixmap);
}

QPixmap PadButton::createPixmap() {
    QPixmap pixmap(width(), height());
    QPainter painter(&pixmap, this);

    painter.setBackgroundColor(white);
    painter.setBackgroundMode(OpaqueMode);

    // Drawing background rectangle
    brush.setStyle(Dense4Pattern);

    if (isEnabled()) {
        pen.setStyle(SolidLine);
        pen.setWidth(1);
        isOn() ? brush.setColor(darkGray) : brush.setColor(lightGray);

    } else {
        pen.setStyle(NoPen);
        brush.setColor(gray);
    }

    painter.setPen(pen);
    painter.setBrush(brush);
    painter.drawRect(0, 0, width(), height());

    // Drawing volume zone
    if (isEnabled()) {
        pen.setColor(black);
        painter.setPen(pen);

        isOn() ? brush.setColor(gray) : brush.setColor(white);
        brush.setStyle(SolidPattern);
        painter.setBrush(brush);

        painter.drawRect(0, volume_position, width(), height() - volume_position);
    }

    return pixmap;
}

void PadButton::mouseMoveEvent(QMouseEvent* e) {
    if (not isEnabled()) {
        return;
    }
    if (e->state() == RightButton) {
        emit volumeChanged(volumePosition2Value(e->pos().y()));
    } 
    update();
}

void PadButton::setVolume(int v) {
    volume_position = 25 - (v / 4);
    update();
}

void PadButton::wheelEvent(QWheelEvent * e) {
    if (e->delta() < 0) {
        if (volume_position < 25) {
            ++volume_position;
        }
    } else {
        if (volume_position > 0) {
            --volume_position;
        }
    }
    emit volumeChanged(volumePosition2Value(volume_position));
    update();
}

int volumePosition2Value(int position) {
    int volume_value = 100 - (position * 4);
    if (volume_value > 100) {
        volume_value = 100;
    } else if (volume_value < 0) {
        volume_value = 0;
    }
    return volume_value;
}

//EOF
