/*
 *   $Id: WavFileDriver.h,v 1.3 2006/03/06 10:33:45 rhizome Exp $
 * 
 *      Copyright (C) 2004, 2005, 2006 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/** 
 * Un driver bas sur le modle "pull" des autres drivers mais qui crit dans un
 * fichier. Avec l'archi actuelle de slag, ce driver n'est pas utilisable car il
 * crit les donnes plus vite qu'elles sont produites, contrairement aux
 * drivers temps-rels qui sont cadences  la frquence du flux audio. Cela
 * donne des fichiers avec de gros vides entres les notes.
 *
 * Ce driver sera peut-tre utilisable  l'avenir mais il faudra implmenter un
 * timer qui tourne  la bonne vitesse, c'est  dire beaucoup plus rapidement.
 * Il faudra pour cela faire quelques calculs savants ;-)
 */

#ifndef WavFileDriver_H
#define WavFileDriver_H

#include <qthread.h>
#include <sndfile.h>

#include "AudioDriver.h"

class WavFileDriver : public AudioDriver, public QThread {
	sample_t * audio_buffer;
        char* filename;
        SNDFILE* wav_file;
        SF_INFO sf_info;
        bool active;
	void run();
    public:
	WavFileDriver(char* filename, process_callback processCallback, int buf_size);
	~WavFileDriver();
	void connect();
	void disconnect();
};

#endif

//EOF 

