/*
 *  $Id: NullDriver.cpp,v 1.5 2006/04/09 00:27:58 rhizome Exp $
 *  
 *      Copyright (C) 2004, 2005, 2006 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "NullDriver.h"

NullDriver::NullDriver(ProcessCallback processCallback, int buf_size) : 
    AudioDriver(processCallback, buf_size),
    active(0),
    audio_buffer(new sample_t[buffer_size])
{ }

NullDriver::~NullDriver() {
    delete[] audio_buffer;
}

void NullDriver::run () { 
    while(active) {
        audioProcessCallback(audio_buffer); 
        // audioProcessCallback() must be called at least as often as with a
        // real audio driver if we want the sound objects to be deleted as if
        // there where read by a true audio thread
        // 10ms is less than 1s / (44100 / 1024)
        msleep(10);
    }
}

void NullDriver::connect()    { 
    active = 1; 
    start(); 
}
void NullDriver::disconnect() { 
    active = 0; 
    wait();
}

//EOF
