/*
 *  $Id: AudioDriver.h,v 1.8 2006/04/09 00:28:39 rhizome Exp $
 *
 *      Copyright (C) 2004, 2005, 2006 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/// Dfinition de l'interface des drivers audio.
/// 
/// Celle-ci est de type "pull", c'est  dire que c'est le driver son qui
/// "appelle" les donnes audionumriques  jouer. L'utilisateur du driver lui
/// fournit une fonction callback en paramtre de son contructeur. Le driver son 
/// appelle cette fonction quand il en a besoin en lui passant un buffer dans
/// lequel il rcupre les donnes.

#ifndef AUDIO_DRIVER_H
#define AUDIO_DRIVER_H

#include "../common.h"
#include "WavFileOutput.h"

typedef void (* ProcessCallback)(sample_t *);
typedef void (* JackErrorCallback)(const char *);

class AudioDriver {
private:
        bool _recording;
protected:
	int buffer_size;
public:
        AudioDriver(ProcessCallback callback, int buf_size = 0) : 
            _recording(false),
            buffer_size(buf_size), 
            file_output(NULL), 
            audioProcessCallback(callback)
        { }
        virtual ~AudioDriver() {}
        WavFileOutput* file_output;
	ProcessCallback audioProcessCallback;
	virtual void connect() = 0;
	virtual void disconnect() = 0;
        inline void enableFileOutput(const QString & filename) {
            file_output = new WavFileOutput(filename);
            _recording = true;
        }
        inline void disableFileOutput() { 
            _recording = false; 
            WavFileOutput* old_file_output = file_output;
            file_output = NULL;
            if (old_file_output != NULL) delete old_file_output;
        }
        inline bool recording() { return _recording; }
};

#endif

//EOF
