## Script (Python) "add_content"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=REQUEST,RESPONSE
##title=Adds Content to a course
##

course_ssid = REQUEST['course_ssid']
title = REQUEST['title']
description = REQUEST['description']
content = REQUEST['content']
languageid = REQUEST['languageid']
username = REQUEST['username']
try:
   requiredfor = REQUEST['requiredfor']
except:
   requiredfor = []
try:
   basedon = REQUEST['basedon']
except:
   basedon = []

child_parentlist = []


"""
	Calculating nodeid
"""

content_ssid = context.gnowql.getlatestVersion('Content')

content_info_dict = context.gnowql.getinfoFromSSID(content_ssid,'gbobjecttypes')
no_of_content = content_info_dict['instances']

if no_of_content == None:
   counter = 2
else:
   counter = len(no_of_content) + 2

content_nodeid='content' + str(counter)


"""
	Getting userid from the username
"""

uid = context.gnowql.getUserIdfromUsername(username)


"""
        Setting default values for title if it has not been specified
"""
if title == '':
	context.REQUEST.RESPONSE.redirect( context.portal_url() + '/'+ 'add_content_form?course_ssid='+ course_ssid +'&'+'msg='+'1' )
        return

if description == ' ':
	description = "No Description has been added to this Content."


dictParameters = context.gnowql.getinfoFromSSID( course_ssid , 'gbobjects' )


newdictParameters = {
        'ssid':course_ssid,
        'uri':dictParameters['uri'],
        'nid':dictParameters['nid'],
        'uid':uid,
        'status':'Public',
        'content':dictParameters['content'],
        'title':dictParameters['title'],
        'description':dictParameters['description'],
        'relations':dictParameters['relations'],
        'instanceof':dictParameters['instanceof']
                    }

context.gnowql.updateO( newdictParameters , 1 )

courseStructure = context.unpickleCourse( course_ssid )
nid = dictParameters['nid']
latest_version_ssid = str(context.gnowql.getlatestVersion( nid ))

"""
	Preparing the dictionary for adding
	the content as an object
"""

dictParameters = {
		'nid':content_nodeid,
		'uid':uid,
		'status':'Public',
		'content':content,
		'title':[title],
		'description':description,
		'instanceof':['Content']
		}

context.gnowql.manageAddObject( dictParameters )

"""
	Getting the latest ssid of the object(Course)
	created.
"""

content_ssid = context.gnowql.getlatestVersion( content_nodeid )
 

"""
  	Preparing a dictionary of parameters for creating
        a relation between a content and the language it
 	is in.
"""

dictParameters = {
		'uid':uid,
		'status':'Public',
		'subject1':content_ssid,
		'subject2':languageid,
		'relationtypes':'encodedin'
		 }

context.gnowql.manageAddRelation( dictParameters )


"""
	Preparing a dictionary of parameters for creating
        a relation between a course and it's content.
"""

dictParameters = {
                'uid':uid,
                'status':'Public',
                'subject1':latest_version_ssid,
                'subject2':content_ssid,
                'relationtypes':'haspart'
                 }

context.gnowql.manageAddRelation( dictParameters )

if requiredfor <> []:
   for elem in requiredfor:
      dictParameters = {
                'uid':uid,
                'status':'Public',
                'subject1':content_ssid,
                'subject2':str(elem),
                'relationtypes':'requires'
                 }

      context.gnowql.manageAddRelation( dictParameters )

if basedon <> []:
   for elem in basedon:
      dictParameters = {
                'uid':uid,
                'status':'Public',
                'subject1':content_ssid,
                'subject2':str(elem),
                'relationtypes':'isbasedon'
                 }

      context.gnowql.manageAddRelation( dictParameters )
      
"""
        Changing the course structure in the pickle.
"""


for y in courseStructure:
   if str(y[0]) == str(course_ssid):
      y[0] = str(latest_version_ssid)
   if str(y[1]) == str(course_ssid):
      y[1] = str(latest_version_ssid)

child_parentlist=[[ str( content_ssid ), str( latest_version_ssid )]]
finalcourseStructure = courseStructure + child_parentlist
context.pickleCourse( latest_version_ssid , finalcourseStructure )

picklelist = ['glossary','link','test','faq','discussion']
latest_courseid = latest_version_ssid
 
for pickle in picklelist:
   check = context.chkExistence(course_ssid,pickle)
   if check == True:
      data = context.unpickleComponent( course_ssid , pickle)
      context.pickleComponent( latest_courseid , pickle , data )

context.REQUEST.RESPONSE.redirect( context.portal_url() + '/refreshparent?courseid=' + latest_version_ssid + '&'+'page=lessonsview' )



