## Script (Python) "add_collection"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=REQUEST,RESPONSE
##title=Adds a collection
##

title = REQUEST['title']
description = REQUEST['description']
categoryids = REQUEST['categoryids']
languageid = REQUEST['languageid']
username = REQUEST['username']
finalcollectionslist=[]
childparentlist=[]


"""
	Calculating nodeid
"""

no_of_collections = context.getallcat('0','3')
counter = no_of_collections + 50
collection_nodeid='coursecategory' + str(counter)


"""
        Setting default values for title if it has not been specified
"""
if title == '':
	title = collection_nodeid
	context.REQUEST.RESPONSE.redirect( context.portal_url() + '/'+ 'add_collection_form?msg='+'1' )
	return
"""
if description == ' ':
	description = "<b"+">"+"No Description has been added to this Collection."+"<b"+" />"
"""

"""
	Getting userid from the username
"""

uid = context.gnowql.getUserIdfromUsername(username)


"""
	Preparing a finallist of collections
	that contains the nids of the ssid's
	in the categoryids list. 
"""

for category in categoryids:
	finalcollectionslist.append( context.gnowql.getnidfromssid( category , 'gbobjecttypes') )
           

"""
	Preparing the dictionary for adding
	the collection as an objectType
"""

dictParameters = {
		'nid':collection_nodeid,
		'uid':uid,
		'status':'Public',
		'content':'',
		'subtypeof':finalcollectionslist,
		'title':[title],
		'description':description
		}
context.gnowql.manageAddObjectType( dictParameters )


"""
	Getting the latest ssid of the objectType(Collection)
	created.
"""

collection_ssid = context.gnowql.getlatestVersion( collection_nodeid )
 

"""
  	Preparing a dictionary of parameters for creating
        a relation between a collection and the language it
 	is in.
"""

dictParameters = {
		'uid':uid,
		'status':'Public',
		'subject1':collection_ssid,
		'subject2':languageid,
		'relationtypes':'encodedin'
		 }

context.gnowql.manageAddRelation( dictParameters )


"""
	Creating a child parent list of the collection
	and it's subcollection to append to the child parent
	list of the collections that has been pickled
"""

for collection in categoryids:
    	 tmplst = []
	 tmplst.append( str(collection_ssid) )
	 tmplst.append( str(collection) )
	 childparentlist.append(tmplst)
				 

"""
	Unpickling the coursecategory pickle
	from the file system
"""

list_of_collections = context.getCatStruct()
flst =  list_of_collections + childparentlist
context.pickleCatStruct( flst ) 


context.REQUEST.RESPONSE.redirect( context.portal_url() + '/frameRefresh' )

