# -*- coding: utf-8 -*-

#  SELF Platform: A distributed web application for collaborative
#  production of learning materials employing open standards.

#  Copyright (C) 2007, 2008 Free Software Foundation Europe e.V.

#  This file is part of the SELF Project, a project administered by the
#  SELF Consortium, for which FSFE acts as copyright holder.

#  The SELF Consortium are:
#    Internet Society Nederland
#    Universitat Oberta de Catalunya
#    Free Software Foundation Europe
#    University of Gothenburg
#    Internet Society Bulgaria
#    Fundacion Via Libre
#    Homi Bhabha Centre for Science Education

#  A complete list of authors can be found in the file AUTHORS.

#  This program is Free Software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.

#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
#  02110-1301, USA.

#  The licensor of SELF Platform is the Free Software Foundation
#  Europe (FSFE), Fiduciary Program, Sumatrastrasse 25, 8006 Zurich,
#  Switzerland, email:ftf@fsfeurope.org.

__docformat__ = 'plaintext'

from genericTable import *
from set_checks import *
from gbvaluerestrictions import *
from gbcontent import *
from storageSpec import *

class gbattributetypes:
	
	def __init__( self, conString ):
		
		self.conn = psycopg2.connect(conString)
		self.cur = self.conn.cursor()
		self.nodetype = 'gbattributetypes'
		

	def set( self, dictParameters, insname ):
		cur = self.cur
		nt = self.nodetype

		vrdict = {}
		try:
			nid = dictParameters['nid']
			s = nid
			s = s.strip()
			print s
			wordlist = s.split()
			nid = ' '.join(wordlist)
		except:
			return "Please Enter NID"
		uid = dictParameters['uid']

		# user will not provide uri, it is calculated after making the directory 

		try:
			content = dictParameters['content']
		except:
			content = ''
			
		try:
			title = dictParameters['title']
		except:
			title = nid
		try:
			status = dictParameters['status']
		except:
			status = 'Public'
		try:
			description = dictParameters['description']
		except:
			description = ''
			
		# Specail fields for attribute types. restrictionref, restrictiontype,
		# subjecttype,

		try:
			vr_description = dictParameters['vr_description']
		except:
			vr_description = None
		try:
			range = dictParameters['range']
		except:
			range = None
		try:
			precision = dictParameters['precision']
		except:
			precision = None
		try:
			regexid = dictParameters['regexid']
		except: 
			regexid = None
		try:
			length = dictParameters['length']
		except:
			length = None

		# datatype is mandatory if restrictionref points to valuerestriction.

		datatype = dictParameters['datatype']
		if datatype == None:
			return "attributetype cannot be set without datatype"

		if datatype <> None:
			vrdict['datatype']=datatype
		if description <> None:
			vrdict['description']=description
		if length <> None:
			vrdict['length']=length
		if range <> None:
			vrdict['range']=range
		if regexid <> None:
			vrdict['regexid']=regexid
		
		# insert datatype etc. in valuerestriction table and
		# collect restrictiontype id

		print vrdict

		obj1 = gbvaluerestrictions(cur)
		restrictionid = obj1.insert(vrdict)
		
		print restrictionid

		# if the restrictionref=0, the  sellist id to be inserted in the table. TODO

	        subtypes = []
	        subtypeof = []
		instanceof = []
		instances = []
		subjects = []

		noofcommits = '1'
		noofchangesaftercommit = '0'
		history = [0]

		relations = []
		relationtypes = []
		attributes = []
		attributetypes = []
		restrictiontype = 0

		restrictionref = restrictionid
		
		# Checks before insertion
		
		nidtbl = tbl_nidinid( cur )
		inid = nidtbl.setval( nid, nt )
		if inid == 0:
			inid = nidtbl.getinid( nid, nt )
	
		inidtbl = tbl_inidssid( cur )
		ssid = inidtbl.setval_using_nid( nid, nt )


		""" uid and uri field is mandatory for objecttypes """

		mandatory_fields = ({'uid':uid, 'restrinctionref':restrictionid, 'restrictiontype':restrictiontype})
		chk_ssid = ({'subtypes':subtypes, 'subtypeof':subtypeof, 'instanceof':instanceof, 'relations':relations, 'instances':instances, 'attributes':attributes, 'relationtypes':relationtypes, 'history':history, 'attributetypes':attributetypes, 'subjects':subjects})
		
		obj = def_set_checks()
		obj.manflds_chk(mandatory_fields)
		status = obj.status(status)
		title = obj.title(title, nid)
		#obj.is_ssid_valid(chk_ssid, cur)


		# check existence of subjecttypes in the gb
		try:
			subjecttypes = dictParameters['subjecttypes']
			st = []
			if subjecttypes <> []:
				for y in subjecttypes:
					try:
						stssid = int(str(obj.get_ssid_from_nid(y, cur)[-1]))
						print stssid
						st.append(stssid)
					except:
						return "subjecttypes do not exist in the gb"
			else:
				return "subjecttypes do not exist in the gb"
		except:
			st = []


		# creating list of networkfield

		listofnbhfield = []

		if st <> []:
			listofnbhfield.append('subjecttypes')
		if relations <> []:
			listofnbhfield.append('relations')
		if relationtypes <> []:
			listofnbhfield.append('relationtypes')
		if attributes <> []:
			listofnbhfield.append('attributes')
		if attributetypes <> []:
			listofnbhfield.append('relations')
		if instanceof <> []:
			listofnbhfield.append('instanceof')
		if instances <> []:
			listofnbhfield.append('instances')
		if subtypeof <> []:
			listofnbhfield.append('subtypeof')
		if subtypes <> []:
			listofnbhfield.append('subtypes')

		# Calculating URI

		preuri = makeURI(nid, inid, nt, insname)
		print preuri

		# get datatypeid

		obj3 = tbl_datatypes( cur )
		datatypeid = obj3.getdtid( datatype )
	
		insertionDict = {
		'status':status,
		'content':content,
		'inid': inid, 
		'subtypes':subtypes,
		'ssid': ssid, 
		'noofcommits':noofcommits,
		'subtypeof':subtypeof,
		'title':title,
		'uri':preuri,
		'relations':relations,
		'noofchangesaftercommit':noofchangesaftercommit,
		'instances':instances,
		'description':description,
		'attributes':attributes,
		'relationtypes':relationtypes,
		'history':history,
		'attributetypes':attributetypes,
		'uid':uid,
		'instanceof':instanceof,
		'subjecttypes':st,
		'datatypeid':datatypeid,
		'restrictionref':restrictionid,
		'restrictiontype':restrictiontype
		}


		insertionDict = obj.insertionDict(insertionDict)

		""" to calculate fieldschanged, noofchangesaftercommit, changetype """
		fieldschanged = obj.fldschd(insertionDict, nt, nid, cur)
		modifications = obj.mod(fieldschanged)
		changetypes = obj.chgtyp(modifications)
	
		insertionDict.update({'fieldschanged':fieldschanged, 'noofchanges':modifications, 'changetype':changetypes})
	
		s = storageSpec()
		gt = genericTable( cur, self.nodetype, s.dictTableNamesAndDefs[ self.nodetype ], s.dictTNamesFDefs[ self.nodetype ], 1 )
		gt.insert( insertionDict )
		
		# creating snapshot at filesystem
		
		createURI(preuri, inid, ssid)

	
		# Setting NBH Props in respective nodes

		obj.set_nbh(ssid, listofnbhfield, cur)


		# creating a pickle using the ssid
		
		dict=self.getNeighbourhood(nid,ssid)
		finaldict=dict[0]
		pickleobject(preuri,ssid,finaldict)
		
		self.conn.commit()
		self.conn.close()

	def getNeighbourhood( self, nid, ssid=0 ):
		"""
		"""
		
		sid = []
		queryResult = []
		cur = self.cur
		listofver = []
		dictofsnaps = {}
		listoffields=['ssid','inid','uid','noofchanges','fieldschanged','changetype','noofcommits','noofchangesaftercommit','history','gbtimestamp','status','uri','title','description','attributetypes','attributes','relationtypes','relations','subtypeof','subtypes','instanceof','instances','restrictiontype','restrictionref','subjecttypes']
		
		obj = def_set_checks()

		if ssid == 0:
		   sid = obj.get_ssid_from_nid(nid, cur)
		else:
		   sid=[ssid]
		
		for x in sid:
			i = 0
			dictofsnaps = {}
			queryResult = cur.execute("select * from view_at where ssid = " + str(x) + ";")
			queryResult = cur.fetchall()
			for y in listoffields:
			    dictofsnaps.update({y:queryResult[0][i]})
			    i=i+1

			print dictofsnaps
			listofver.append(dictofsnaps)

		return listofver

	def updateDatatype( self, ssid, newDatatypeName ):
		"""
		updateDatatype( ssid, newDatatypeName )

		logic:
		------
		1. get the dtid of new datatype
		2. get the ntid of the node i.e. gbattributetypes
		3. create a new value restriction entry
		4. get the restrictionid of value restriction entry
		5. insert restrictionid in the field_restrictionref
		6. get the fid generated in 4
		7. update the given ssid to the new fid
		"""
		cur = self.cur

		# get the dtid of the new datatype
		dtobj = tbl_datatypes( cur )
		datatypeid = dtobj.getdtid( newDatatypeName )
		print "dtid of %s is %s" % ( newDatatypeName, datatypeid )

		# get the ntid
		obj = tbl_nodetype( cur )
		ntid = obj.getntid( 'gbattributetypes' )

		# create the new value restriction
		obj1 = gbvaluerestrictions( cur )

		vrdict = {
			'datatype':newDatatypeName,
# 			'description':None,
# 			'range':None,
# 			'precision':None,
# 			'regexid':None,
# 			'length':None
			}
		restrictionid = obj1.insert( vrdict )
		print "restriction id is %s" % restrictionid


		# create instance of storageSpec
		s = storageSpec()

		# create instance of the field table
		ft = tbl_field( cur, s.dictTNamesFDefs[ 'gbattributetypes' ][ 'restrictionref'] )

		# this is the dtid of the field in which we're inserting the restrictionid
		# this is different from the datatypeid that we calculated above
		dtt = tbl_datatypes( cur )
		dtid = dtt.getdtid( s.dictTNamesFDefs['gbattributetypes' ]['restrictionref'][1] )
		
		fid = ft.insert( { 'ntid' : ntid, 'datatypeid' : dtid, 'value' : restrictionid  } )

		# update the SSID of the AT

		query = "UPDATE gbattributetypes SET restrictionref=%s WHERE ssid=%s;"
		print "Running update: %s" % ( query % ( fid, ssid ) )
		cur.execute( query, ( fid, ssid ) )

		self.conn.commit()
		print "Updated!"
		
	
	
if __name__ == "__main__":
	dictConn = { 
		'dbname':'self', 
		'username':'akula', 
		'password':'akula', 
		'host':'127.0.0.1'
		}
	
	connstr = "dbname=%(dbname)s user=%(username)s password=%(password)s host=%(host)s" % dictConn

	ob = gbattributetypes( connstr )
	ob.updateDatatype( 283, 'int8[]' )
