#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################
# Contributor: "Dinesh Joshi" <dinesh.joshi@yahoo.com>

import pickle

if __name__ == '__main__':
    """
    This script generates a pickled object which stores the authentication
    information for the postgres database. The usage is as follows:
        1. Keyword = any identifying word such as testServer. Its just a key.
        2. Username = Postgres username
        3. Password = Postgres password
        4. host = IP / Hostname of the Postgres server

    The format of the dict is simple:
       { 'keyword': { host info. dict }, 'keyword2' : { } .... }

       host info dict contains three key:value pairs viz. username, password, host.
    """
    dictConnInfo = { '<enter some keyword here eg. my_db_server>':
                         { 'username':'<enter your username here>',
                           'password':'<enter your password here>',
                           'host':'<enter your host here>',
                         },
                     'other':
                         { 'username':'<enter your username here>',
                           'password':'<enter your password here>',
                           'host':'<enter your host here>',
                         },
                   }

    fp = open( 'connInfo.pyPickle', 'w' )
    pickle.dump( dictConnInfo, fp )
    fp.close()

    fp = open( 'connInfo.pyPickle', 'r' )
    info = pickle.load( fp )
    fp.close()

    print "pickled object successfully!"
