## Script (Python) "add_glossary"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=REQUEST,RESPONSE
##title=Adds Glossary to a Course
##

course_ssid = REQUEST['course_ssid']
word = REQUEST['word']
definition = REQUEST['definition']
languageid = REQUEST['languageid']
username = REQUEST['username']
listofAttributeDict = []

"""
	Calculating nodeid
"""

glossary_ssid = context.gnowql.getlatestVersion('Glossary')

glossary_info_dict = context.gnowql.getinfoFromSSID(glossary_ssid,'gbobjecttypes')
no_of_glossary = glossary_info_dict['instances']

if no_of_glossary == None:
   counter = 2
else:
   counter = len(no_of_glossary) + 2

glossary_nodeid = 'glossary' + str(counter)

if word == "":
   word = glossary_nodeid
   context.REQUEST.RESPONSE.redirect( context.portal_url() + '/'+ 'add_glossary_form?course_ssid='+ course_ssid +'&'+'msg='+'1' )
   return 

if definition == "":
   definition = "No definition has been added to this glossary."


"""
	Getting userid from the username
"""

uid = context.gnowql.getUserIdfromUsername(username)

"""
	Preparing the dictionary for adding
	the glossary as an object
"""

dictParameters = {
		'nid':glossary_nodeid,
		'uid':uid,
		'status':'Public',
		'content':"",
		'title':[word],
		'description':definition,
		'instanceof':['Glossary']
		}

context.gnowql.manageAddObject( dictParameters )

"""
	Getting the latest ssid of the object(Glossary)
	created.
"""

glossary_ssid = context.gnowql.getlatestVersion( glossary_nodeid )
 

"""
  	Preparing a dictionary of parameters for creating
        a relation between a glossary and the language it
 	is in.
"""

dictParameters = {
		'uid':uid,
		'status':'Public',
		'subject1':glossary_ssid,
		'subject2':languageid,
		'relationtypes':'encodedin'
		 }

context.gnowql.manageAddRelation( dictParameters )


"""
	Preparing a dictionary of parameters for creating
        a relation between a course and the glossary.The
 	relationtype is 'haspart'.
"""

dictParameters = {
                'uid':uid,
                'status':'Public',
                'subject1':course_ssid,
                'subject2':glossary_ssid,
                'relationtypes':'haspart'
                 }

context.gnowql.manageAddRelation( dictParameters )

exists = context.chkExistence(course_ssid,'glossary')
alphabets = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'

if exists == False:
   datalist = [[['A',[]],['B',[]],['C',[]],['D',[]],['E',[]],['F',[]],['G',[]],['H',[]],['I',[]],['J',[]],['K',[]],['L',[]],
               ['M',[]],['N',[]],['O',[]],['P',[]],['Q',[]],['R',[]],['S',[]],['T',[]],['U',[]],['V',[]],['W',[]],['X',[]],
               ['Y',[]],['Z',[]],['a',[]],['b',[]],['c',[]],['d',[]],['e',[]],['f',[]],['g',[]],['h',[]],['i',[]],['j',[]],
               ['k',[]],['l',[]],['m',[]],['n',[]],['o',[]],['p',[]],['q',[]],['r',[]],['s',[]],['t',[]],['u',[]],['v',[]],
               ['w',[]],['x',[]],['y',[]],['z',[]],['others',[]]],[]]

   context.pickleComponent( course_ssid , 'glossary' , datalist )

datalist = context.unpickleComponent( course_ssid , 'glossary')

firstalphabet = word[0]
posofalphabet = 0
if firstalphabet in alphabets:
   posofalphabet = alphabets.index(firstalphabet)
else:
   posofalphabet = 52

datalist[0][posofalphabet][1].append([str(glossary_ssid),word])
datalist[1].append(str(glossary_ssid))
context.pickleComponent( course_ssid , 'glossary' , datalist )

context.REQUEST.RESPONSE.redirect( context.portal_url() + '/refreshparent?courseid=' + course_ssid +'&'+'page=glossaryview' )



