# -*- coding: utf-8 -*-

#  SELF Platform: A distributed web application for collaborative
#  production of learning materials employing open standards.

#  Copyright (C) 2007, 2008 Free Software Foundation Europe e.V.

#  This file is part of the SELF Project, a project administered by the
#  SELF Consortium, for which FSFE acts as copyright holder.

#  The SELF Consortium are:
#    Internet Society Nederland
#    Universitat Oberta de Catalunya
#    Free Software Foundation Europe
#    University of Gothenburg
#    Internet Society Bulgaria
#    Fundacion Via Libre
#    Homi Bhabha Centre for Science Education

#  A complete list of authors can be found in the file AUTHORS.

#  This program is Free Software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.

#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
#  02110-1301, USA.

#  The licensor of SELF Platform is the Free Software Foundation
#  Europe (FSFE), Fiduciary Program, Sumatrastrasse 25, 8006 Zurich,
#  Switzerland, email:ftf@fsfeurope.org.

__docformat__ = 'plaintext'

import os
import psycopg2
import psycopg2.extras
from initProps import *
from checkdifference import *
from storageSpec import *
from genericTable import *

class def_set_checks:
	
	def insertionDict(self, insertionDict):
		nullvales = []
		for li in insertionDict:
			#print li
			if str(insertionDict[li]) == '[]':
				#print "true"
				nullvales.append(li)
			if str(insertionDict[li]) == '':
				nullvales.append(li)
		for li in nullvales:
			del(insertionDict[li])
		return insertionDict
		
	
	def manflds_chk(self, mandatory_fields):
		for li in mandatory_fields:
			#print "li is"
			#print li
			#print mandatory_fields[li]
			if mandatory_fields[li] == '':
				print  "field " + li + " cannot be blank.."
				os._exit(99)
			if str(mandatory_fields[li]) == '[]':
				print  "field " + li + " cannot be blank.."
				os._exit(99)


	def fldschd(self, dictionary, nodetypes, nid, cur):
		#print "nodetypes is --- ", nodetypes
		nt = nodetypes
		list_dictionary = []
		set_props_nodetypes = []
		fieldschanged= []
		fieldschanged_new = []
		#x = []
		#x = props_objecttypes
		#print x
		
		nodetype_names = [ 'gbobjecttypes', 'gbattributetypes', 'gbmetatypes', 'gbrelationtypes', 'gbobjects', 'gbattributes', 'gbrelations', 'gbusers', 'gbusertypes' ]
		
		#print "props_objecttypes ---------------",props_objecttypes
		
		properties = ( {  'props_objecttypes':props_objecttypes, 'props_attributetypes':props_attributetypes, 'props_metatypes':props_metatypes, 'props_relationtypes':props_relationtypes, 'props_objects':props_objects, 'props_attributes':props_attributes, 'props_relations':props_relations, 'props_users':props_users, 'props_usertypes':props_usertypes } )
		
		#print "properties  -----  ", properties
		
		for li in nodetype_names:
			if li == nodetypes:
				li_ftw_args = str(li[0]) + str(li[1])
				nodetypes = li.lstrip(li_ftw_args)
				nodetypes = 'props_' + nodetypes
				for li in properties:
					if li == nodetypes:
						prop_nodetypes =  properties[li]
		
		for li in dictionary.keys():
			list_dictionary.append(li)

		#print prop_nodetypes

		print prop_nodetypes
		set_props_nodetypes = set(prop_nodetypes)
		print set_props_nodetypes
		
		set_list_dictionary = set(list_dictionary)	
		
		compare = set_list_dictionary.intersection(set_props_nodetypes)
		list_compare = list(compare)
		
		for li in dictionary:
			for x in list_compare:
				if li == x:
					y = dictionary[li]
					if y <> '':
						fieldschanged.append(li)
					
		print "fieldschanged is ===>>>",fieldschanged
		modi = len(fieldschanged)
		print "modi is --", modi
		return fieldschanged
		
		
		
		
		
		#ssid = self.get_ssid_from_nid(inid, cur, nodetypes)
		#print ssid

		#qryrslt =cur.execute("select max(ssid) from " + nodetypes + ";")
		#qryrslt = cur.fetchall()
		#print "qryrslt is for max ssid------", qryrslt
		#farg = qryrslt[0]
		#ssid = farg[0]
		
		#+++++++++++
		#print nt
		##print inid
		#print nid
		#qryrslt = cur.execute("select a.inid from gbnidinid a, datatypes_varchar b, gbnodetypes c  where b.vid = a.nid and c.nodename = '" + nt + "' and c.ntid = a.ntid and b.value = '" + nid + "' ;")
		#qryrslt = cur.fetchall()
		#print qryrslt
		#farg = qryrslt[0]
		##print farg
		#inid = farg[0]
		#print inid
		
		#qryrslt =cur.execute("select max(ssid) from " + nt + " where inid = " + str(inid) + ";")
		#qryrslt = cur.fetchall()
		#print "qryrslt is for max ssid------", qryrslt
		#if str(qryrslt) <> '[]':
			#farg = qryrslt[0]
			#max_ssid = farg[0]
			#print max_ssid
		#else:
			#return fieldschanged
		
		#for li in fieldschanged:
			#print li
			#print "for this we are finding all the values ------- ", li
			#qryrslt =cur.execute("select " + li + " from " + nt + " where ssid = " + str(max_ssid) + ";")
			#qryrslt = cur.fetchall()
			##print "qryrslt is ------", qryrslt
			#farg = qryrslt[0]
			#value = farg[0]
			#print "value from nodetypes is ---", value
			
			#field_table = "field_" + li
			#print "field table is ",field_table
			#if str(value) <> 'None':
				#qryrslt = cur.execute("select a.value from datatypes_varchar a, " + field_table + " b where a.vid = b.vid and b.fid = " + str(value) + ";")
				#qryrslt = cur.fetchall()
				##farg = qryrslt[0]
				##prev_value = farg[0]
				#print "prev value present intable is --- ",qryrslt
			
			#dict_val = dictionary[li]
			#"""
			#for y in nw_type_props:
				#print "nw tyapes props are - ", y
					
				#dict_val = dictionary[li]
				#print dict_val
				#if li == y:
					#print dict_val
					#for x in dict_val:
						##dict_val = dict_val[0]
						#dict_val = x
						#print "inside dict value is --- ", dict_val
						#print "inside field table is --- ", field_table
						#qryrslt = cur.execute("select a.fid from " + field_table + " a, datatypes_int8_array b where b.vid = a.vid and b.value = '{" + str(x) + "}';")
						#qryrslt = cur.fetchall()
						##print qryrslt
						#farg = qryrslt[0]
						#prev_value = farg[0]
						#print "prev value is ====== ",prev_value
			#"""
			
			#for z in nw_type_props:
			
				##if li == 'instanceof':
				#if li == z:
					#print dict_val
					#if str(dict_val) <> '[]':
						#print "true"
						#for li in dict_val:
							##qryrslt = cur.execute("select a.fid from " + field_table + " a, datatypes_int8_array b where b.vid = a.vid and b.value = ARRAY%s " % dict_val) 
							#print "select vid from " + field_table + " where fid = '" + str(li) + "'"
							#qryrslt = cur.execute("select vid from " + field_table + " where fid = '" + str(li) + "'; ")
							#qryrslt = cur.fetchall()
							#print qryrslt
							#farg = qryrslt[0]
							##prev_value = farg[0]
							#print "prev value is ====== ",farg

			#prev_value = value
			#print "value supplied this time is ---", dict_val
			#print "value supplied prev time is ---",prev_value
			
			#if prev_value <> dict_val:
				#print "diffffffff"
				#fieldschanged_new.append(li)
				#print "$dictionary appended...$"
				#print fieldschanged_new
				
		#return fieldschanged_new
		#print dictionary
		#+++++++++++



	def mod(self, fieldschanged):
		
		modification = len(fieldschanged)
		print "modification is ===>>>", modification
		return modification


	def chgtyp(self, modification)	:
		
		changetype=[]
		
		for x in range(0,modification):
			changetype.append(1)
			
		return changetype	


	def status(self, status):
		if status == '':
			status = 'public'
		return status
		
	def title(self, title, nid):
		nid_arr = []
		if str(title) == '[]':
			title = nid
			nid_arr.append(title)
			return nid_arr
		else:
			return title
		
	def instanceof(self, instanceof):
		if str(instanceof) == '[]':
			print "object should have minimum one instanceof relations."
			os._exit(99)
			
	def subjects_rel(self, subjects):
		if len(subjects) < 2:
			print "object should have minimum two subjects."
			os._exit(99)

	def subjects_rettype(self, subjects, arity, nt):
		if len(subjects) < 2:
			print "object should have minimum two subjects."
			os._exit(99)
		if nt == 'gbrelationtypes':
			print arity
			print len(subjects)
			if arity <> str(len(subjects)):
				print "subjects required to be equal to the arity"
				os._exit(99)

	def tra_ref_sym(self, tra_ref_sym):
		print tra_ref_sym
		for li in tra_ref_sym:
			if str(tra_ref_sym[li]) == '':
				tra_ref_sym[li] = 2
		return tra_ref_sym
		
	def is_ssid_valid(self, chk_ssid, cur):
		self.cur = cur
		dict = {}
		#print "the dictionary is given as ........."
		#print chk_ssid
		for li in chk_ssid:
			#print "chk_ssid are as follows"
			#print li
			#print chk_ssid[li]
			if str(chk_ssid[li]) == '[]':
				print "the " + li + " is blank"
			else:
				for x in chk_ssid[li]:
					#print x
					qryrslt = self.cur.execute("select count(ssid) from gbinidssid where ssid = " + str(x) + ";")
					qryrslt = cur.fetchall()
					#print qryrslt
					farg = qryrslt[0]
					count = farg[0]
					#print count
					#print farg
					if count == 1:
						print "ssid is exists in the gbinidssid for " + li + " and valid for the input."
						dict.update({li:chk_ssid[li]})
						
					else:
						print "ssid doesn't exists in the gbinidssid for " + li + " and not valid for the input"
						os._exit(99)
		#print "the dict is given as ...................................."
		print dict
			#print chk_ssid[li]
			

	def get_ssid_from_nid(self, nid,  cur):
		self.cur = cur
		qryrslt = self.cur.execute("select a.ssid from gbinidssid a, gbnidinid b, datatypes_varchar c where a.inid = b.inid and c.vid = b.nid and c.value = '" + nid + "';")
		list_ssid = cur.fetchall()
		listofssid = []
		for x in list_ssid:
			listofssid.append(x[0])
			
		return listofssid
	
# 	def get_ssid_from_nid(self, inid, cur, nodetypes):
# 		print inid
# 		qryrslt = cur.execute("select max(a.ssid) from " + nodetypes + " where inid = " + str(inid) + ";")
# 		qryrslt = cur.fetchall()
# 		farg = qryrslt[0]
# 		ssid = farg[0]
# 		print ssid
# 		return ssid


	#def possible_att(self, ssid, cur):
		
		#self.cur = cur
		
		#""" given a ssid, collect instanceof value and then goto each item of the instanceof, collect attributetypes from the item and append to a list, return list. id nodetype is type thn take both instanceof and subtypeof"""
		
		#poss_att = []
		
		#nodetypes = def_set_checks.get_nodetypes_from_ssid(self, ssid, cur)
		##return nodetypes
		#print nodetypes
		#nodetypes_instanceof = nodetypes + "_instanceof"
		
		#typelist = [ 'gbusertypes', 'gbobjecttyeps', 'gbattributetypes', 'gbrelationtypes', 'gbmetatypes' ]
		
		
		#qryrslt = self.cur.execute("select b.vid from " + nodetypes + " a,  field_instanceof b where a.ssid = " + str(ssid) + " and a.instanceof = b.fid;")
		#qryrslt = self.cur.fetchall()
		#print qryrslt
		#farg = qryrslt[0]
		#instanceof = farg[0]
		##print instanceof
		
		#""" after collecting the ssid of instanceof, find nodetypes. """
		
		#instof_nodetypes = get.get_nodetypes_from_ssid(self, ssid)
		
		#nodetypes_attributetypes = instof_nodetypes + "_attributetypes"
		
		#qryrslt = self.cur.execute("select b.attributetypes_value from " + instof_nodetypes + " a, " + nodetypes_attributetypes + " b where a.ssid = " + instanceof + " and a.attributetypes_value = b.attributetypes_value;")
		#qryrslt = self.cur.fetchall()
		#farg = qryrslt[0]
		#attributetypes= farg[0]
		##print attributetypes
				
		#poss_att.append(attributetypes)
		#print poss_att
		
		#for li in typelist:
			#if nodetypes == li:
				#nodetypes = def_set_checks.get_nodetypes_from_ssid(self, 81)
				##return nodetypes
				##print nodetypes
				#nodetypes_subof = nodetypes + "_subtypeof"
		
				#typelist = [ 'gbusertypes', 'gbobjecttyeps', 'gbattributetypes', 'gbrelationtypes', 'gbmetatypes' ]
		
		
				#qryrslt = self.cur.execute("select b.instanceof_value from " + nodetypes + " a, " + nodetypes_subof + " b where a.ssid = " + ssid + " and a.instanceof_fid = b.instanceof_fid;")
				#qryrslt = self.cur.fetchall()
				#farg = qryrslt[0]
				#subof = farg[0]
				##print instanceof
		
				#""" after collecting the ssid of instanceof, find nodetypes. """
		
				#instof_nodetypes = get.get_nodetypes_from_ssid(self, ssid)
		
				#nodetypes_attributetypes = instof_nodetypes + "_attributetypes"
		
				#qryrslt = self.cur.execute("select b.attributetypes_value from " + instof_nodetypes + " a, " + nodetypes_attributetypes + " b where a.ssid = " + subof + " and a.attributetypes_value = b.attributetypes_value;")
				#qryrslt = self.cur.fetchall()
				#farg = qryrslt[0]
				#subtypes = farg[0]
				##print subtypes
				#poss_att.append(attributetypes)
				
		#print poss_att
		#return poss_att
			
			
			
			
	#""" to get the nodetypes from given ssid. """

	#def get_nodetypes_from_ssid(self, ssid, cur):
		#self.cur = cur
		#print "sssid is "
		#print ssid
		##try:
		#qryrslt = self.cur.execute("select b.nodename from gbinidssid a, gbnodetypes b where a.ntid = b.ntid and a.ssid = " + str(ssid) + ";")
					   ##select b.nodename from gbinidssid a, gbnodetypes b where a.ntid = b.ntid and a.ssid =  22 ;
		#qryrslt = self.cur.fetchall()
		##print qryrslt
		#farg = qryrslt[0]
		##print farg
		#nodetype = farg[0]
		##print nodetype
		#return nodetype
		##except:
		##	print "ssid not present in gbinidssid"



	def getNeighbourhood( self, nid ):
		"""
		"""
		
		sid = []
		queryResult = []
		cur = self.cur
		listofver = []
		dictofsnaps = {}
		listoffields=['ssid','inid','uid','noofchanges','fieldschanged','changetype','noofcommits','noofchangesaftercommit','history','gbtimestamp','status','uri','title','description','attributetypes','attributes','relationtypes','relations','instanceof','structure','content']
		
		obj = def_set_checks()
		sid = obj.get_ssid_from_nid(nid, cur)
		
		for x in sid:
			i = 0
			dictofsnaps = {}
			queryResult = cur.execute("select * from generico where ssid = " + str(x) + ";")
			queryResult = cur.fetchall()
			for y in listoffields:
			    dictofsnaps.update({y:queryResult[0][i]})
			    i=i+1

			print dictofsnaps
			listofver.append(dictofsnaps)

		return listofver



	def fields_string(self, fields_list):
		fields = ""
		counter = 0
		string = ''
		for li in fields_list:
			if counter <> len(fields_list)-1:
				value = li + ", "
				fields = fields + value
				print fields
				counter = counter + 1
		fields_string = "( " + fields + ")"
		print "fields_string is --- ", fields_string
		
		for x in fields_string:
			if counter-len(fields_string) == -3:
				x = ''
			else:
				string = string + x
			counter = counter + 1
		#print string
		return string


	def get_nid_from_ssid1(self, ssid, cur):
		qryrslt = cur.execute("SELECT a.value FROM datatypes_varchar a, gbobjects, gbnidinid WHERE gbnidinid.nid = a.vid AND gbnidinid.inid = gbobjects.inid and ssid = %s;" % ssid )
		qryrslt = cur.fetchall()
		print qryrslt
		#nid = qryrslt
		nid = qryrslt[0][0]
		print nid
		return nid

	def get_nid_from_ssid(self, ssid, cur):
		# , gbnodetypes.nodename AS nodename, ssid 
		query = "SELECT datatypes_varchar.value AS nid FROM gbnidinid, gbinidssid, datatypes_varchar, gbnodetypes WHERE gbnidinid.inid = gbinidssid.inid AND gbnidinid.nid = datatypes_varchar.vid AND gbnidinid.ntid = gbnodetypes.ntid AND gbinidssid.ssid = '%s';" % ssid

		qryrslt = cur.execute( query )
		qryrslt = cur.fetchall()
		nid = qryrslt[0][0]
		print nid
		return nid


		


	def update_versionfields(self, dictionary, nodetype, commit, cur):
		
		nt = nodetype
		fieldschanged_update = []
		dictofsnaps = {}
		nodechanged = {}
		fieldschanged_dict = {}
		fieldschanged = []
		changetype = []
		
		""" to get the value of nodetypes as givenin the __init__ specifications for properties."""

		# Removing gb from nodetype
		
		nodetype_fields = nt_props_dict_new[nt]
		print nodetype_fields
		
		""" to get the values for the specific node from the respective view."""
		view_table = nt_view_dict[nt]

		""" to get the value of ssid """
		try:
			ssid = dictionary['ssid']
		except:
			print "ssid not provided."
		
		""" keys are the values which we want to use in the select query."""
		keys = tuple(nodetype_fields)
		
		keys_list = []
		for li in keys:
			keys_list.append(li)
		print keys_list
		
		""" string manipulation for keys_list to make it in format required in the query statement."""
		nodetype_fields_string = str(keys_list)
		x = nodetype_fields_string.replace("[","")
		y = x.replace("]","")
			
		#nodetype_fields_tuple = str(keys)
		nodetype_fields_string = y.replace("'", "")
		
		""" to get all the values from the views with respective nodetypes."""
		qryrslt = cur.execute("select " + nodetype_fields_string + " from " + view_table + " where ssid = " + str(ssid) + ";")
		print "select " + nodetype_fields_string + " from " + view_table + " where ssid = " + str(ssid) + ";"
		qryrslt = cur.fetchall()
		print qryrslt
		result = qryrslt[0]
		
		""" to get the dictionary for keys and value from the specific view with respect to the given nodetype."""
		i = 0
		for keys in keys:
			nodechanged.update({keys:result[i]})
			i = i +1
			
		print nodechanged
				
		""" to delele the value of ssid from the dictionary."""
		del dictionary['ssid']
		
		""" dictionary without ssid """
		print dictionary
		print ssid
		
		""" to get the nid from the ssid."""
		try:
			qryrslt = cur.execute("SELECT a.value FROM datatypes_varchar a, gbobjects, gbnidinid WHERE gbnidinid.nid = a.vid AND gbnidinid.inid = gbobjects.inid and ssid = " + ssid + ";")
			qryrslt = cur.fetchall()
			nid = qryrslt[0]
			print nid
		except:
			print "nid value is not present for that ssid - wrong entry"
			
		""" comparision of arrays of nodechanged and dictionary."""
		
		""" to make the node specific property name for nodetype without gb."""
		ntnaked = nt.replace('gb','')
		ns_properties = "ns_props_" + ntnaked
		print ns_properties
		
		""" to make the network specific property name for nodetype without gb."""
		nw_properties = "nw_props_" + ntnaked
		print nw_properties


		""" to get the list of specific fields for specific nodetypes."""
		
		""" for objecttypes."""
		if ns_properties == 'ns_props_objecttypes':
			ns_props = ns_type_props + [ 'content' ]
			print ns_props
		if nw_properties == 'nw_props_objecttypes':
			nw_props = nw_type_props + [ 'structure' ]
			print nw_props
			
		""" for metatypes."""
		if ns_properties == 'ns_props_metatypes':
			ns_props = ns_type_props + [ 'content' ]
			print ns_props
		if nw_properties == 'nw_props_metatypes':
			nw_props = [ nw_type_props_mt ]
			print nw_props

		""" for relationtypes."""
		if ns_properties == 'ns_props_relationtypes':
			ns_props = ns_type_props + [ 'istransitive', 'isreflexive', 'issymmetrical' ]
			print ns_props
		if nw_properties == 'nw_props_relationtypes':
			nw_props = nw_type_props + [ 'roletypes' ]
			print nw_props

		""" for objects."""
		if ns_properties == 'ns_props_objects':
			ns_props = ns_type_props + [ 'content' ]
			print ns_props
		if nw_properties == 'nw_props_objects':
			nw_props = nw_type_props + [ 'structure' ]
			print nw_props

		""" for attributes."""
		if ns_properties == 'ns_props_attributes':
			ns_props = ns_token_props + [ 'sentense' ]
			print ns_props
		if nw_properties == 'nw_props_attributes':
			nw_props = nw_token_props + [ 'subject', 'value' ]
			print nw_props

		""" for relations."""
		if ns_properties == 'ns_props_relations':
			ns_props = ns_token_props + [ 'sentense' ]
			print ns_props
		if nw_properties == 'nw_props_relations':
			nw_props = nw_token_props + [ 'subject1', 'subject2']
			print nw_props



		""" generating the ns_dictionary - checking that only those values will be present in this dictionary which are present in the ns_dictionary with respect to the new dictionary user is providing.."""
		ns_dictionary = {}
		for x in ns_props:
			for y in dictionary:
				if x == y:
					print "x in ns is  ------",x
					print dictionary[x]
					ns_dictionary.update({x:dictionary[x]})
		print ns_dictionary
		
		""" generating the nw_dictionary - checking that only those values will be present in this dictionary which are present in the ns_dictionary with respect to the new dictionary user is providing.."""
		nw_dictionary = {}
		for x in nw_props:
			for y in dictionary:
				if x == y:
					print "x in nw is  ------",x
					print dictionary[x]
					nw_dictionary.update({x:dictionary[x]})
		print nw_dictionary

		
		""" version calculation for ns properties."""
		
		for li in ns_dictionary:
			print "li is ---",li
			for x in nodechanged:
				#print x
				if x == li:
					print "nodechanged[x] is ---",nodechanged[x]
					print "dictionary[li] is ---",dictionary[li]
					
					
					chk_obj = checkdifference(nodechanged[x], dictionary[li])
					
					""" to check if the value is inserted or not."""
					insert = chk_obj.checkforinsert()
					print insert
					if str(insert) == 'True':
						changetype.append(1)
						
					""" to check if the value is updated or not."""
					update = chk_obj.checkforupdate()
					#print "updates value is - ",update
					if str(update) == 'True':
						#print "changetype is === ", changetype
						changetype.append(2)
						#print changetype
					
					""" to check if the value is deleted or not."""
					delete = chk_obj.checkfordelete()
					if str(delete) == 'True':
						changetype.append(0)
					

					
					
					if nodechanged[x] == dictionary[li]:
						print "same as the old value."
					else:
						fieldschanged_dict.update({li:dictionary[li]})
		print fieldschanged_dict
		
		
		""" version calculation for nw properties."""
		
		for li in nw_dictionary:
			print "li is ---",li
			for x in nodechanged:
				#print x
				if x == li:
					print "nodechanged[x] is ---",nodechanged[x]
					print "dictionary[li] is ---",dictionary[li]
					"""we have to make long each of the ssid presnted in the nw_props"""
					#for z in dictionary[li]:
						#print z
						#a = long(z)
						#print a
					chk_obj = checkdifference(nodechanged[x], dictionary[li])
					#chk_obj.checkforupdate()
					
					""" to check if the value is inserted or not."""
					insert = chk_obj.checkforinsert()
					print insert
					if str(insert) == 'True':
						changetype.append(1)
						
					""" to check if the value is updated or not."""
					update = chk_obj.checkforupdate()
					#print "updates value is - ",update
					if str(update) == 'True':
						#print "changetype is === ", changetype
						changetype.append(2)
						#print changetype
					
					""" to check if the value is deleted or not."""
					delete = chk_obj.checkfordelete()
					if str(delete) == 'True':
						changetype.append(0)
					
					
					if (nodechanged[x]) == (dictionary[li]):
						print "same as the old value for nw_props."
					else:
						fieldschanged_dict.update({li:dictionary[li]})
		print fieldschanged_dict
		
		
		
		for li in fieldschanged_dict:
			fieldschanged.append(li)
			
		noofchanges = len(fieldschanged)
			
		print "fieldschanged is --- ",fieldschanged
		print "changetype is --- ",changetype
		print "noofchanges is --- ",noofchanges
		
		
		""" to get the noofchanges, noofchangesaftercommit, history."""
		
		qryrslt = cur.execute("select noofcommits, noofchangesaftercommit, history from " + view_table + " where ssid = " + str(ssid) + ";")
		qryrslt = cur.fetchall()
		#print qryrslt
		ver_flds_old_node = qryrslt[0]
		print ver_flds_old_node

		# new method for the noof commits...
		#nid = get_nid_from_ssid(ssid, cur)
		#qryrslt = cur.execute("select max(noofcommits) from " + view_table + ";")
		#qryrslt = cur.fetchall()
		#noofcommits = qryrslt[0][0]
		
		ver_flds_old_node_dict = {}
		ver_flds_keys = ['noofcommits', 'noofchangesaftercommit', 'history']
		
		""" to get the dictionary of version fields with values."""
		i = 0
		for li in ver_flds_old_node:
			print li
			ver_flds_old_node_dict.update({ver_flds_keys[i]:li})
			i = i + 1
		print ver_flds_old_node_dict

                # new method for the noof commits...
		dict_dj_views = {'gbattributes':'djview_a', 'gbattribuettypes':'djview_at', 'gbobjects':'djview_o', 'gbobjecttypes':'djview_ot', 'gbrelations':'djview_r', 'gbrelationtypes':'djview_rt', 'gbusers':'djview_u', 'gbusertypes':'djview_ut'}
		dj_view_table = ''
		for li in dict_dj_views:
			if str(li) == str(nt):
				dj_view_table = dict_dj_views[li]
		print "the views using for noofcommit query is ---", dj_view_table
				
		
                nid = self.get_nid_from_ssid(ssid, cur)
                qryrslt = cur.execute("select max(noofcommits) from " + dj_view_table + " where nid = '" + nid + "';")
                qryrslt = cur.fetchall()
                noofcommits = qryrslt[0][0]								
		
		ver_flds_new_node_dict = {}
		
		
		if commit == 1:
			ver_flds_old_node_dict.update({'noofcommits':noofcommits})
			noofcommits = ver_flds_old_node_dict['noofcommits']
			noofcommits = noofcommits + 1
			noofchangesaftercommit = 0
			ver_flds_new_node_dict.update({'noofcommits':noofcommits, 'noofchangesaftercommit':noofchangesaftercommit})
		#print ver_flds_old_node_dict
		
		if commit == 0:
			noofcommits = ver_flds_old_node_dict['noofcommits']
			print "dj_view_table", dj_view_table
			print "select max(noofchangesaftercommit) from " + dj_view_table + "  where nid = '" + nid + "' and noofcommits = " + str(noofcommits) + ";"
			qryrslt = cur.execute("select max(noofchangesaftercommit) from " + dj_view_table + "  where nid = '" + str(nid) + "' and noofcommits = " + str(noofcommits) + ";")
			qryrslt = cur.fetchall()
			print qryrslt
			noofchangesaftercommit = qryrslt[0][0]
			#noofchangesaftercommit = ver_flds_old_node_dict['noofchangesaftercommit']
			noofchangesaftercommit = noofchangesaftercommit + 1
			ver_flds_new_node_dict.update({'noofcommits':noofcommits, 'noofchangesaftercommit':noofchangesaftercommit})

		
		history = ver_flds_old_node_dict['history']
		history_counter = []
		for x in history:
			counter = int(x)
			history_counter.append(counter)
		history = history_counter
		ssid = int(ssid)	
		history.append(ssid)
		#print history
		ver_flds_new_node_dict.update({'history':history})
		print ver_flds_new_node_dict
		
		ver_flds_new_node_dict.update({'fieldschanged':fieldschanged, 'changetype':changetype, 'noofchanges':noofchanges})
		
		print "output of fun --- === >>>", ver_flds_new_node_dict

		return ver_flds_new_node_dict
		


	#def noofchanges(self, fieldschanged):
		#noofchanges = len(fieldschanged)
		#return noofchanges


	#def changetype(self, fieldschanged):
		#qryrslt = self.cur.execute("")

	#def mod(self, fieldschanged):
		
		#modification = len(fieldschanged)
		#return modification


	#def chgtyp(self, modification)	:
		
		#changetype=[]
		
		#for x in range(0,modification):
			#changetype.append(1)
			
		#return changetype

	def set_nbh(self, current_ssid, supplied_field_names, cur):
		
		#obj.set_nbh(10, ['instanceof'], cur)
		""" current_ssid is the node that is set or updated. current_fieldname is the modified field name. the fieldnames must belong to nw fields. 
		"""
		
		current_field_list = ['instanceof', 'subtypeof', 'subject', 'subject1', 'subject2', 'subjecttypes', 'role1', 'role2']
		
		dict = {'instanceof':'instances', 'subtypeof':'subtypes', 'subject':'attributes', 'subject1':'relations', 'subject2':'relations', 'subjecttypes':'attributetypes', 'role1':'relationtypes', 'role2':'relationtypes', 'subject1':'relations','subject2':'relations'}
		
		""" check is the values in current fields names exists in the current_field_list."""
		
		nodetype = self.get_nodetypes_ssid(current_ssid, cur)
		#print nodetype
		
		view = nt_view_dict[nodetype]
		#print view
		
		value_dict = {}
		
		print "Printing Supplied Fields *********** :", supplied_field_names

		for li in supplied_field_names:
			nbh_field_name = dict[li]
			print "Value of LI",li
			
			if li <> 'role1' and li <> 'role2':
				
				print "Inside if for role1 role2"
				qryrslt = cur.execute("select " + li + " from " + view + " where ssid = " + str(current_ssid) + ";")
			else:
				newqury = cur.execute("select roletypes from view_rt where ssid = " + str(current_ssid) + ";")
				newqury = cur.fetchall()
				farg = newqury[0]
				roletypes = farg[0]

				for ctr in roletypes:
					qryrslt = cur.execute("select " + li + " from gbroletypes where rtid = " +  str(ctr) + ";")

			qryrslt = cur.fetchall()
			farg = qryrslt[0]
			value = farg[0]			
			a=[]

			if li <> 'subject1' and li <> 'subject2' and li <> 'subject':
				if str(value) <> 'None':
					for z in value:
						value = int(z)
						a.append(value)
			else:
				print "Inside subject if"
				a.append(value)
				print "the vlue of a ----------------------", a

			value_dict.update({li:a})

			
		nbh_dict = {}
		nbh = []
		
		for li in value_dict:
			if str(value_dict[li]) <> '[]':
				fieldname = li
				nbh_field_name = dict[fieldname]
				#print nbh_field_name
				nbh_dict.update({nbh_field_name:current_ssid})
				print nbh_dict
				ssid = value_dict[li]
				print ssid			# arrays of ssids
				
				for li in ssid:
					nodetype = self.get_nodetypes_ssid(li, cur)
					#print nodetype
					view = nt_view_dict[nodetype]
					
					qryrslt = cur.execute("select " + nbh_field_name + " from " + view + " where ssid = " + str(li) + ";")
					print "select " + nbh_field_name + " from " + nodetype + " where ssid = " + str(li) + ";"
					qryrslt = cur.fetchall()
					farg = qryrslt[0]
					current_value = farg[0]
					
					
					print "Current val From Query Result ;;;", current_value
					if str(current_value) == 'None':
						current_value = []
						temp_val = []
					else:
						temp_val = [] 
						for x in current_value:
							temp_val.append(int(x))
					current_value = []
					current_value = temp_val
					
					print "Current ssid _now !!!!! :::::  ", current_ssid
					current_value.append(int(current_ssid))
					print "Final List of Attributes >>>>>>>>>>>>>>>>>>   ",current_value
					
					""" updating the value in the table. """
					
					
					s = storageSpec()
					flddef = s.dictTNamesFDefs[nodetype][nbh_field_name]
					
					obj = tbl_nodetype( cur )
					ntid = obj.getntid( nodetype )
					
					dtobj = tbl_datatypes( cur )
					dtid = dtobj.getdtid( flddef[1] )
					
					ft = tbl_field( cur, flddef )
					fid = ft.insert( { 'ntid':ntid, 'datatypeid':dtid, 'value':current_value } )
					print "Fid generated was %s" % fid
					
					print "update " + nodetype + " set " + nbh_field_name + " = " + str(fid) + " where ssid = " + str(li) + ";"
					cur.execute("update " + nodetype + " set " + nbh_field_name + " = " + str(fid) + " where ssid = " + str(li) + ";")
					
					
	
	def get_nodetypes_ssid(self, ssid, cur):
		#print ssid
		qryrslt = cur.execute("select a.nodename from gbnodetypes a, gbinidssid b where a.ntid = b.ntid and b.ssid = " + str(ssid) + "")
		qryrslt = cur.fetchall()
		farg = qryrslt[0]
		nodetype = farg[0]
		return nodetype
	def possible_attributes(self, ssid, cur):
		
		""" check instanceof of the node and goto the parent's attributetypes and append to a list. check subtypeof of the node and append to list."""
		
		possible_attributes = []
		
		nodetype = self.get_nodetypes_ssid(ssid, cur)
		print "nodetype is ---", nodetype
		view = nt_view_dict[nodetype]
		
		
		""" to find out the value of instanceof."""
		qryrslt = cur.execute("select instanceof from " + view + " where ssid = " + str(ssid) + ";")
		qryrslt = cur.fetchall()
		farg = qryrslt[0]
		instanceof = farg[0]
		print "instanceof already present in view is ---", instanceof
		
		""" if nodetype is in the type_list then it will find out subtypeof also."""
		type_list = ['gbattributetypes', 'gbrelationtypes', 'gbobjecttypes', 'gbmetatypes', 'gbusertypes']
		
		subtypeof = []
		if nodetype in type_list:
			qryrslt = cur.execute("select subtypeof from " + view + " where ssid = " + str(ssid) + ";")
			qryrslt = cur.fetchall()
			farg = qryrslt[0]
			subtypeof = farg[0]
			print "subtypeof already present in view is ---", subtypeof
			
		
		""" to find the attributetypes from instanceof."""
		if str(subtypeof) == 'None':
			print "yes"
			subtypeof = []
		if str(instanceof) == 'None':
			print "yes"
			instanceof = []
		print subtypeof
		print instanceof
		parents = subtypeof + instanceof
		
		if str(parents) == '[]':
			possible_attributes = []
			return
		
		for li in parents:
			nodetype = self.get_nodetypes_ssid(li, cur)
			view = nt_view_dict[nodetype]
			
			print "select attributetypes from " + view + " where ssid = " + str(li) + ";"
			qryrslt = cur.execute("select attributetypes from " + view + " where ssid = " + str(li) + ";")
			qryrslt = cur.fetchall()
			farg = qryrslt[0]
			attributetypes = farg[0]
			print "attributetypes are ---", attributetypes
			possible_attributes.append(attributetypes)
			
		return possible_attributes



	def possible_relations(self, ssid, cur):
		
		""" check instanceof of the node and goto the parent's relationtypes and append to a list. check subtypeof of the node and append to list."""
		
		possible_relations = []
		
		nodetype = self.get_nodetypes_ssid(ssid, cur)
		print "nodetype is ---", nodetype
		view = nt_view_dict[nodetype]
		
		
		""" to find out the value of instanceof."""
		qryrslt = cur.execute("select instanceof from " + view + " where ssid = " + str(ssid) + ";")
		qryrslt = cur.fetchall()
		farg = qryrslt[0]
		instanceof = farg[0]
		print "instanceof already present in view is ---", instanceof
		
		""" if nodetype is in the type_list then it will find out subtypeof also."""
		type_list = ['gbattributetypes', 'gbrelationtypes', 'gbobjecttypes', 'gbmetatypes', 'gbusertypes']
		
		subtypeof = []
		if nodetype in type_list:
			qryrslt = cur.execute("select subtypeof from " + view + " where ssid = " + str(ssid) + ";")
			qryrslt = cur.fetchall()
			farg = qryrslt[0]
			subtypeof = farg[0]
			print "subtypeof already present in view is ---", subtypeof
			
		
		""" to find the relationtypes from instanceof."""
		if str(subtypeof) == 'None':
			print "yes"
			subtypeof = []
		if str(instanceof) == 'None':
			print "yes"
			instanceof = []
		print subtypeof
		print instanceof
		parents = subtypeof + instanceof
		
		if str(parents) == '[]':
			possible_relations = []
			return
		
		
		for li in parents:
			nodetype = self.get_nodetypes_ssid(li, cur)
			view = nt_view_dict[nodetype]
			
			print "select relationtypes from " + view + " where ssid = " + str(li) + ";"
			qryrslt = cur.execute("select relationtypes from " + view + " where ssid = " + str(li) + ";")
			qryrslt = cur.fetchall()
			farg = qryrslt[0]
			relationtypes = farg[0]
			print "relationtypes are ---", relationtypes
			possible_relations.append(relationtypes)
			
		return possible_relations
			
			
	def chk_relation(self, ssid, relationtype_ssid, cur):
		
		"""check if the given ssid can have relations. return 1 is possible and 0 if not."""
		possible_relations = self.possible_relations(ssid, cur)
		
		if relationtype_ssid in possible_relations:
			return 1
		else:
			return 0
		
	def chk_attribute(self, ssid, attributetype_ssid, cur):
		
		"""check if the given ssid can have attributes. return 1 is possible and 0 if not."""
		possible_attributes = self.possible_attributes(ssid, cur)
		
		if attributetype_ssid in possible_attributes:
			return 1
		else:
			return 0	



if __name__ == '__main__':
	obj = def_set_checks()
		
	dictConn = { 
		'dbname':'aaa', 
		'username':'akula', 
		'password':'akula', 
		'host':'158.144.44.131'
	}

	conn = psycopg2.connect( "dbname=%(dbname)s user=%(username)s password=%(password)s host=%(host)s" % dictConn )
	cur = conn.cursor()
	fieldschanged = obj.update_versionfields({'ssid':'10', 'title':'[mumbai, india]', 'status':'Public','subtypeof':[5,9,0], 'instanceof':[2], 'description':'test8', 'attributes':[5]}, 'gbobjecttypes',0, cur)
	#obj.noofchanges(fieldschanged)
	


