# -*- coding: utf-8 -*-

#  import.py, Importing a SCORM archive

#  Copyright (C) 2007 Free Software Foundation Europe e.V.

#  This file is part of the SELF Project, a project administered by the
#  SELF Consortium, for which FSFE acts as copyright holder.

#  The SELF Consortium are:
#    Internet Society Nederland
#    Universitat Oberta de Catalunya
#    Free Software Foundation Europe
#    University of Gothenburg
#    Internet Society Bulgaria
#    Fundacion Via Libre
#    Homi Bhabha Centre for Science Education

#  A complete list of authors can be found in the file AUTHORS.

#  This program is Free Software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.

#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
#  02110-1301, USA.

#  The licensor of <Program Name> is the Free Software Foundation Europe
#  (FSFE), Fiduciary Program, Sumatrastrasse 25, 8006 Zurich,
#  Switzerland, email:ftf@fsfeurope.org.

__author__ = """Divya <divyas15@gmail.com>, Prasanta Kumar Baruah <prasanta.baruah@gmail.com>"""
__docformat__ = 'plaintext'

from Products.selfApp.Extensions.manifest import xml_logger
import os, sys, re, pickle
import shutil
import xmlrpclib

def exportArchive(self, SSID, REQUEST):
    #ID = SSID
    #return SSID
    export_file = ''
    username = REQUEST['AUTHENTICATED_USER']
    
    ins_home = INSTANCE_HOME
    username = str(username)
    #instance_name = self.getInstanceName()
    #conpath = 'http://'+instance_name
    #return conpath
    #con = xmlrpclib.Server(conpath)

    inspath = self.portal_url()
    splitpath = inspath.split('/')
    inst_name = str(splitpath[-1])
    #instance_name = self.REQUEST['BASE2']
    #return SSID
    info = self.gnowql.getinfoFromSSID(SSID, 'gbobjects')
    f_name = info['title'][0]
    #struct = file(".pickle")
    #cour_struct = pickle.load(struct)
    #return info
    cour_struct = self.unpickleCourse( SSID)
    struct = self.displaytree(cour_struct)
    #return struct
    uniqueNids = []
    for pair in cour_struct:
        if pair[0] == '0' or pair[1] == '0':
            continue

        if pair[0] not in uniqueNids:
            uniqueNids.append( pair[0] )

        if pair[1] not in uniqueNids:
            uniqueNids.append( pair[1] )

    print "unique nids: %s" % uniqueNids
    info_list = {}
    instance_list = {}
    for pair in uniqueNids:
        temp_info = self.gnowql.getinfoFromSSID(pair, 'gbobjects')
        node_type = self.gnowql.getNodetype(str(temp_info['instanceof'][0]))
        instance_name = self.gnowql.getinfoFromSSID(str(temp_info['instanceof'][0]), node_type)
        instance_list[pair] = instance_name['title']
        info_list[pair] = temp_info

    
    
    #f_name = self.kb.getNeighbourhood(ID, 'object', ['title'])[0]
    f = f_name.split(' ')
    for name_len in range(len(f)):
        if name_len == 0:
            export_file = export_file + f[name_len]
        else:
            export_file = export_file + '_'+ f[name_len]
                                                     
    if os.path.exists("/tmp/"+username+"Export"):
        shutil.rmtree("/tmp/"+username+"Export")

    os.system('mkdir /tmp/'+username+'Export')

    
    os.mkdir("/tmp/"+username+"Export/"+"resources")

    #Remove checkCondition file
    """
    xl = xml_file()
    resource = xl.xml_manifest(ID, conpath, username)
    print "resource"
    """
    
    f= open('/tmp/'+username+'Export/imsmanifest.xml', 'w')
    xl = xml_logger(f, 'utf-8',  username, inst_name)
    resource = xl.write_entry(SSID, struct, info_list, instance_list, CLIENT_HOME )
    xl.close()
    f.close()

    #Seems unnecessary
    """
    try:
        os.system('cp -r validationScript/ /tmp/')
        print "File Copied"
    except:
        print "File Can not be copied"
    """
        
    os.system('cd /tmp/'+username+'Export/; zip -r '+export_file+'.zip'+ ' resources/; zip -j '+export_file+'.zip '+ ins_home+'/Products/selfApp/Extensions/validationScript/*; zip -j '+export_file+'.zip'+' imsmanifest.xml')
#    os.system('zip -j '+export_file+'.zip'+' validationScript/*')

    #Uploading the zip archieve to plone is not required now
    
    fp = open('/tmp/'+username+'Export/'+export_file+'.zip')
    try:
        expId = export_file
        expId = expId.replace(':','')
        expId = expId.replace('?','')
        expId = expId.replace('%','')
        expId = expId.replace('#','')
        expId = expId.replace('&','')
        expId = expId.replace('*','')
        expId = expId.replace('@','')
        expId = expId.replace('!','')
        expId = expId.replace('~','')
        expId = expId.replace(':','')

        listofobj = []
        
        for x in self.objectValues():
            listofobj.append(x.getId())
        
        if expId+'.zip' in listofobj:
            self.manage_delObjects([expId+'.zip'])
                       
        self.manage_addFile(id=expId+'.zip', file=fp, title=export_file, precondition=' ', content_type='application/zip')
    except:
        expId = "Course"+str(SSID)


        listofobj = []
        
        for x in self.objectValues():
            listofobj.append(x.getId())
        if expId+'.zip' in listofobj:
            self.manage_delObjects([expId+'.zip'])
        
        self.manage_addFile(id=expId+'.zip', file=fp, title=export_file, precondition=' ', content_type='application/zip')
        

    print "File added"

    fp.close()
    """
    expId = export_file
    expId = expId.replace(':','')
    expId = expId.replace('?','')
    expId = expId.replace('%','')
    expId = expId.replace('#','')
    expId = expId.replace('&','')
    expId = expId.replace('*','')
    expId = expId.replace('@','')
    expId = expId.replace('!','')
    expId = expId.replace('~','')
    expId = expId.replace(':','')
    """    
    #os.system('cd /tmp;rm -rf '+username+'Export')

    self.REQUEST.RESPONSE.redirect(expId+'.zip')
    
