<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: user_home.php,v 1.40 2005/09/23 14:42:56 toddy Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2001 (c) Free Software Foundation
#
#  Copyright 2003-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
# 
# The Savane project is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# The Savane project is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with the Savane project; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

site_header(array('title'=>_("User Profile"),'toptab'=>'people'));

 
# Assumes $res_user result handle is present

if (!$res_user || db_numrows($res_user) < 1) 
{
  exit_error('No Such User','No Such User');
}

# permit to the user to specify something 
$form_opening = '<form action="'. $PHP_SELF .'" method="post">';
if ($detailed)
{ $checked = " selected"; }
$pagestyle .= '<select name="detailed"><option value="0">'._("basic").'</option><option value="1"'.$checked.'>'._("detailed").'</option></select>';
$form_submit = '<input type="submit" class="bold" value="'._("Apply").'">';

# I18N
# %s currently is "basic" or "detailed"
print html_show_displayoptions(sprintf(_("Show %s information."), $pagestyle),
			       $form_opening,
			       $form_submit);

print '<br />';


print html_splitpage(1);

if ($detailed)
{
  $artifacts = array("support", "bugs", "task", "patch");
  
  function specific_print_items ($criterion, $user_id) 
    {
      # Print full info for the still opened items, just list the remaining.
      $k = 1;
      reset($GLOBALS['artifacts']);
      while (list(,$artifact) = each($GLOBALS['artifacts']))
	{
	  $sql='SELECT bug_id,group_id,date,summary,status_id,privacy '.
	     ' FROM '.$artifact.
	     ' WHERE  '.$criterion.'='.$user_id.' ORDER BY date DESC';
	  $result = db_query($sql);
	  $rows = db_numrows($result);
	  if ($result && $rows > 0) 
	    {
	      for ($j=0; $j<$rows; $j++) 
		{
		  # Private items are simply ignored
		  if (db_result($result,$j,'privacy') != 2)
		    {
		      if (db_result($result,$j,'status_id') == 1)
			{
			  $k++;
			  print '<a href="'.$GLOBALS['sys_home'].$artifact.'/?func=detailitem&amp;item_id='.db_result($result,$j,'bug_id').'">';
			  print '['.$artifact.' #'.db_result($result,$j,'bug_id').', '.format_date($sys_datefmt,db_result($result,$j,'date')).']<br />&nbsp;&nbsp;';
			  print group_getname(db_result($result,$j,'group_id')).': '.db_result($result,$j,'summary');
			  print '</a>';
			  print '</td></tr><tr><td colspan="2" class="'.utils_get_alt_row_color($k).'">'."\n\n";
			}
		      else
			{ 
			  $closed .= '<a href="'.$GLOBALS['sys_home'].$artifact.'/?func=detailitem&amp;item_id='.db_result($result,$j,'bug_id').'">';
			  $closed .= '['.$artifact.' #'.db_result($result,$j,'bug_id').']';
			  $closed .= '</a>, ';
			}
		      $exists = 1;
		    }
		}
	    }            
	}
      if ($closed)
	{ echo _("Closed:").' '.substr($closed,0,-2).'.'; }
      
      if (!$exists)
	{ echo '<font class="warn">'._("None found.").'</font>'; }
      
    }

  $HTML->box1_top(sprintf(_("Items submitted by %s"),db_result($res_user,0,'realname')));
  # FIXME: News item are missing
  specific_print_items("submitted_by", db_result($res_user,0,'user_id'));  
  $HTML->box1_bottom();
      
  print '<br /><br />';

  $HTML->box1_top(sprintf(_("Items assigned to %s"),db_result($res_user,0,'realname')));
  # FIXME: News item are missing
  specific_print_items("assigned_to", db_result($res_user,0,'user_id'));
  $HTML->box1_bottom();
  


print html_splitpage(2);
}


$HTML->box1_top(_("General Information"));

print '
<br />
<table width="100%" cellpadding="0" cellspacing="0" border="0">
<tr valign="top">
	<td>'._("Login Name:").' </td>
	<td><b>'.db_result($res_user,0,'user_name').'</b></td>
</tr>
<tr valign="top">
	<td>'
	._("Real Name:").' </td>
	<td><b>'.db_result($res_user,0,'realname').'</b></td>
</tr>
<tr valign="top">
	<td>'
	._("User ID:").' </td>
	<td><b>#'.db_result($res_user,0,'user_id').'</b></td>
</tr>
<tr valign="top">
	<td>'._("Email Address:").' </td>
	<td>
	<b><a href="'.$GLOBALS['sys_home'].'sendmessage.php?touser='.db_result($res_user,0,'user_id').'">';

if (db_result($res_user,0,'email_hide') == "1") {
	print _("Send him/her a mail");

} else {
	print utils_antispam_email(db_result($res_user,0,'email'));
}

print '</a></b>
	</td>
</tr>
<tr valign="top">
	<td>'
	._("Site Member Since").':
	</td>
	<td>
		<b>'.format_date(false,db_result($res_user,0,'add_date')).'</b>
	</td>
</tr>
<tr valign="top">
	 <td></td>
	 <td><p>';

if (db_result($res_user,0,'people_view_skills') != 1) {
	print _("This user has set his/her profile to private").'.';
} else {
	print '<a href="'.$GLOBALS['sys_home'].'people/viewprofile.php?user_id='.db_result($res_user,0,'user_id').'"><b>'._("View Skills/Resume").'</b></a>';
}

print '</p>
	</td>
</tr>
';

if (db_result($res_user,0,'gpg_key') != "") {	
	print '<tr valign="top"><td></td><td>';
	print	'<a href="'.$GLOBALS['sys_home'].'people/viewgpg.php?user_id='.db_result($res_user,0,'user_id').'"><b>'._("View GPG Key").'</b></a>';
	print '</td></tr>';
}

print '</table>';

$HTML->box1_bottom();

if (!$detailed) 
{
  print html_splitpage(2);

}
else
{
  print '<br /><br />';
}

print $HTML->box_top(_("Project/Group Information"),'',1);
# now get listing of groups for that user

$sql = "SELECT groups.group_name,"
. "groups.group_id,"
. "groups.unix_group_name,"
. "groups.status,"
. "user_group.admin_flags, "
. "group_history.date "
. "FROM groups,user_group,group_history "
. "WHERE groups.group_id=user_group.group_id "
. "AND user_group.user_id='".$user_id."' "
. "AND groups.status='A' "
. "AND groups.is_public='1' "
. "AND (group_history.field_name='Added User' OR group_history.field_name='Approved User' OR user_group.admin_flags='P')"
. "AND group_history.group_id=user_group.group_id "
. "AND group_history.old_value='".db_result($res_user,0,'user_name')."' "
. "GROUP BY groups.unix_group_name "
. "ORDER BY groups.unix_group_name";

$result = db_query($sql);
$rows = db_numrows($result);

# Unlike in mygroups, we dont check if the history is broken or not.
# We assume it is ok.

$j = 1;
unset($content);
for ($i=0; $i<$rows; $i++)
{
  $content .= '<li class="'.utils_get_alt_row_color($j).'">';  
  $content .= '<a href="'.$GLOBALS['sys_home'].'projects/'. db_result($result,$i,'unix_group_name') .'/">'.db_result($result,$i,'group_name').'</a><br />';
  if (db_result($result,$i,'date'))
    {
# If the group history is flawed (site install problem), the
# date may be unavailable
      $content .= '<font class="smaller">'.sprintf(_("Member since %s"), strftime('%B %Y',db_result($result,$i,'date'))).'</font>';
    }
  $content .= '</li>';
      $exists=1;
      $j++;
    }

if (!$exists)
{
  print _("This user is not a member of any Project/Group");
}
else
{
  print '<ul class="boxli">'.$content.'</ul>';
}
unset($exists);

print $HTML->box_bottom(1);


print html_splitpage(3).'<p class="clearr">&nbsp;</p>';

if (user_isloggedin()) {
	sendmail_form_message($GLOBALS['sys_home'].'sendmessage.php', $user_id);

} else {
	echo '<h3>'._("You Could Send a Message if you were logged in").'.</h3>';
  
}
 



$HTML->footer(array());

?>
