<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: pre.php,v 1.84 2005/09/19 08:41:19 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2003 (c) Free Software Foundation
#
#  Copyright 2002-2004 (c) Mathieu Roy <yeupou--at--gna.org>
#
# The Savane project is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# The Savane project is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with the Savane project; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

# Defines all of the Savane hosts, databases, etc.
# This needs to be loaded first because the lines below depend upon it.
if (getenv('SAVANE_CONF'))
{ require getenv('SAVANE_CONF').'/savannah.conf.php'; }
elseif (getenv('SV_LOCAL_INC_PREFIX'))
{ require getenv('SV_LOCAL_INC_PREFIX').'/savannah.conf.php'; }
else
{
  # go back to default location
  require '/etc/savannah/savannah.conf.php';
}

if ($GLOBALS['sys_url_topdir'] != '/')
{
  $sys_home = $GLOBALS['sys_url_topdir'].'/';
}
else
{
  $sys_home = $GLOBALS['sys_url_topdir'];
}

# Defines the https url, if available -- no path is added since this
# variable can be used with REQUEST_URI added.
if (isset($GLOBALS['sys_https_host']))
{
  $sys_https_url = 'https://'.$GLOBALS['sys_https_host'];
}
else
{
  $sys_https_url = 'http://'.$GLOBALS['sys_default_domain'];
}



# require_directory
# sources (requires) all specific include files of a module from
# the include area (all include files of a module are arranged
# in subdirectories in the includes area, so this routine sources
# just all of the *.php files found in the module's subdirectory).

# Prevent declaration by users.
if ($_GET['module'] ||
    $_POST['module'] ||
    $_COOKIE['module'] ||
    $_SERVER['module'] ||
    $_ENV['module'] ||
    $_FILES['module'] ||
    $_REQUEST['module'])
{ exit(); }

function require_directory ($module)
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':require_directory ($module) ';
  if ($module=="")
    { return; }
  if ($GLOBALS['directory_'.$module.'_is_loaded'])
    { return; }

  $dir = $GLOBALS['sys_www_topdir'].'/include/'.$module;
  if (is_dir($dir))
    {
      $odir = opendir($dir);
      while ($file = readdir($odir))
	{
	  if (eregi(".*\.(php)$", $file))
	    {
	      require $dir."/".$file;
	    }
	}
      closedir($odir);
    }

  $GLOBALS['directory_'.$module.'_is_loaded'] = 1;
}

function get_module_include_dir ($phpself, $true_artifact=0, $true_dir=0)
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':get_module_include_dir ($phpself, $true_artifact=0, $true_dir=0) ';
  $guess = basename(dirname($phpself));

  if (!$true_dir && $guess == "admin")
    {
      # Need to go deeper
      $guess = basename(dirname(dirname($phpself)));
    }

  if (!$true_artifact) {
    # we have some special cases:
    #  - bugs, patch, task go in trackers
    #  - news and forum go in news
    if (($guess == 'bugs') ||
	($guess == 'patch') ||
	($guess == 'task') ||
	($guess == 'support'))
      {
	$guess = 'trackers';
      }
    else if (($guess == 'forum'))
      {
	$guess = 'news';
      }

  }

  return $guess;
}

/**************************************************************
       Usual requires, always useful
**************************************************************/

# version info
require $GLOBALS['sys_www_topdir'].'/include/version.php';

# i18n setup
require $GLOBALS['sys_www_topdir'].'/include/i18n.php';

# base error library for new objects
require $GLOBALS['sys_www_topdir'].'/include/Error.class';

# database abstraction
require $GLOBALS['sys_www_topdir'].'/include/database.php';

# user functions like get_name, logged_in, etc
require $GLOBALS['sys_www_topdir'].'/include/user.php';

# various html utilities
require $GLOBALS['sys_www_topdir'].'/include/utils.php';

# security library
require $GLOBALS['sys_www_topdir'].'/include/session.php';

# theme - color scheme informations
require $GLOBALS['sys_www_topdir'].'/include/theme.php';

# title, helper to find out appropriate page title
require $GLOBALS['sys_www_topdir'].'/include/title.php';

# HTML layout class, may be overriden by the Theme class
require $GLOBALS['sys_www_topdir'].'/include/Layout.class';

$HTML = new Layout();

# group functions like get_name, etc
require $GLOBALS['sys_www_topdir'].'/include/Group.class';

# member functions like member_add, member_approve, etc
require $GLOBALS['sys_www_topdir'].'/include/member.php';

# library to set up context help
require $GLOBALS['sys_www_topdir'].'/include/help.php';

# exit_error library
require $GLOBALS['sys_www_topdir'].'/include/exit.php';

#  send mail library
require $GLOBALS['sys_www_topdir'].'/include/sendmail.php';

# various html libs like button bar, themable
require $GLOBALS['sys_www_topdir'].'/include/html.php';

# graphics library
require $GLOBALS['sys_www_topdir'].'/include/graphs.php';

# calendar library
require $GLOBALS['sys_www_topdir'].'/include/calendar.php';

# forms library
require $GLOBALS['sys_www_topdir'].'/include/form.php';

# search tools, frequently needed
require_directory('search');

# left-hand nav library, themable
require $GLOBALS['sys_www_topdir'].'/include/menu.php';


/**************************************************************
       Set up proper use of UTF-8, even if the webserver does
       not serve it by default
**************************************************************/

header("Content-Type: text/html; charset=utf-8");


/**************************************************************
       Start user session
**************************************************************/

# Connect to db
db_connect();

# sys_unix_group_name is maybe defined
# in this case, we want sys_group_id
if (isset($GLOBALS['sys_unix_group_name']))
{
  $search_group = $GLOBALS['sys_unix_group_name'];
  $res_grp = db_query("SELECT group_id FROM groups WHERE unix_group_name='$search_group'");
  $sys_group_id = db_result($res_grp,0,'group_id');
}


# determine if they're logged in
session_set();

# set up the user's timezone if logged in
# redirect them from http to https if asked in their session table
if (user_isloggedin())
{
  putenv('TZ='.user_get_timezone());

  if (!session_issecure() && session_needsstayinssl())
    {
      if ($GLOBALS['sys_https_host'] )
	{
	  header('Location: https://'.$GLOBALS['sys_https_host'].$REQUEST_URI);
	}
    }
}


/**************************************************************
       Defines every information useful
       in case of a project page
**************************************************************/

# defines the artifact we are using
define("ARTIFACT", get_module_include_dir($GLOBALS['REQUEST_URI'], 1));

# Keep only numerical characters in the item_id
if ($item_id && !ctype_digit($item_id))
{
  preg_match("/(\d+)/", $item_id, $match);
  $item_id = $match[0];
}

# if we got an item_id and no group_id we need to get the appropriate
# group_id
if (!isset($group_id) && !isset($group_name) && isset($item_id))
{
  $result = db_query("SELECT group_id FROM ".ARTIFACT." WHERE bug_id='$item_id'");
  if ($result)
    {  $group_id = db_result(($result),0,'group_id'); }
}

# if we got a forum_id and no group_id, we need to get the appropriate
# group_id
# (FIXME: in the future it could follow the naming scheme of trackers)
if (!isset($group_id) && !isset($group_name) && isset($forum_id))
{
  $result = db_query("SELECT group_id FROM forum_group_list WHERE group_forum_id='$forum_id'");
  if ($result)
    {  $group_id = db_result(($result),0,'group_id'); }
}

# if we got a msg_id and no group_id, we need to get the appropriate
# group_id
# (FIXME: in the future it could follow the naming scheme of trackers)
if (!isset($group_id) && !isset($group_name) && isset($msg_id))
{
  $result = db_query("SELECT forum_group_list.group_id,forum_group_list.forum_name,forum.group_forum_id,forum.thread_id FROM forum_group_list,forum WHERE forum_group_list.group_forum_id=forum.group_forum_id AND forum.msg_id='$msg_id'");
  if ($result)
    {  $group_id = db_result(($result),0,'group_id'); }
}


# defines group_id if group is set
# defines group_name if group_id is set
if (isset($group) && !isset($group_id))
{
  $res_grp = db_query("SELECT group_id,status FROM groups WHERE unix_group_name='$group'");
  $group_id = db_result($res_grp,0,'group_id');
  $group_name = $group;
}
elseif (isset($group_id))
{
  $res_grp = db_query("SELECT unix_group_name,status FROM groups WHERE group_id='$group_id'");
  $group_name = db_result($res_grp,0,'unix_group_name');
}

# If group_id is defined, we are on a project page, we have several checks
# to make
if (isset($group_id))
{
  # Ignore status of the project if being registered
  if (db_result($res_grp,0,'status') != 'I')
    {
      # Check if the project is active
      if (db_result($res_grp,0,'status') != 'A')
	{
          # No active but in Maintenance mode, it is ok for super user
	  if (db_result($res_grp,0,'status') == 'M' && !user_is_super_user())
	    {
	      exit_error("This project is in maintenance mode.");
	    }
	  elseif (db_result($res_grp,0,'status') == 'M' && user_is_super_user())
	    {
	      fb(_("Note: this project is in maintenance mode"));
	    }
	  elseif (!user_is_super_user())
	    {
              # Other cases, no access granted
	      exit_error("This project is not in active state.");
	    }
	}
    }

  # check if we are on the correct page
  # (you can avoid it with $no_redirection=1)
  # if getTypeBaseHost() = "", we use the default host
  if (isset($group_id) && !$no_redirection)
    {
      $project = project_get_object($group_id);
      if ($HTTP_HOST != $project->getTypeBaseHost() && $project->getTypeBaseHost())
	{
	  header ('Location: http'.(session_issecure()?'s':'').'://'.$project->getTypeBaseHost().$_SERVER["REQUEST_URI"]);
	  exit;
	}
    }
}

# Finally, if requires/include for an artifact exists, load them all
# In any case, set the $artifact variable.
require_directory(get_module_include_dir($GLOBALS['PHP_SELF']));

?>
