<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: reporting.php,v 1.15 2004/03/13 18:22:06 yeupou Exp $
#
#  Copyright 2001-2002 (c) Laurent Julliard, CodeX Team, Xerox
#
#  Copyright 2002-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

if ($group_id && member_check(0,$group_id, member_create_tracker_flag(ARTIFACT).'2'))
{

  # Initialize the global data structure before anything else
  trackers_init($group_id);

  include ($GLOBALS['sys_urlroot'].'/include/HTML_Graphs.php');

  if ($field)
    {
      if ($field == 'aging')
	{
	  trackers_header(array ("title"=>_("Aging Report")));
	  echo "\n<h1>"._("Aging Report")."</h1>";

	  $time_now=time();
	  #			echo $time_now."<P>";

	  for ($counter=1; $counter<=8; $counter++)
	    {

	      $start=($time_now-($counter*604800));
	      $end=($time_now-(($counter-1)*604800));

	      $sql="SELECT avg((close_date-date)/86400) FROM ".ARTIFACT." WHERE close_date > 0 AND (date >= $start AND date <= $end) AND resolution_id <> '2' AND group_id='$group_id'";

	      $result = db_query($sql);

	      $names[$counter-1]=format_date("m/d/y",($start))." to ".format_date("m/d/y",($end));
	      $values[$counter-1]=db_result($result, 0,0);
	    }

	  GraphIt($names, $values, _("Average Turnaround Time For Closed Items"));

	  echo "<p>";

	  for ($counter=1; $counter<=8; $counter++)
	    {

	      $start=($time_now-($counter*604800));
	      $end=($time_now-(($counter-1)*604800));

	      $sql="SELECT count(*) FROM ".ARTIFACT." WHERE date >= $start AND date <= $end AND resolution_id <> '2' AND group_id='$group_id'";

	      $result = db_query($sql);

	      $names[$counter-1]=format_date("m/d/y",($start))." to ".format_date("m/d/y",($end));
	      $values[$counter-1]=db_result($result, 0,0);
	    }

	  GraphIt($names, $values, _("Number of Items Opened"));

	  echo "<p>";

	  for ($counter=1; $counter<=8; $counter++)
	    {

	      $start=($time_now-($counter*604800));
	      $end=($time_now-(($counter-1)*604800));

	      $sql="SELECT count(*) FROM ".ARTIFACT." WHERE date <= $end AND (close_date >= $end OR close_date < 1 OR close_date is null) AND resolution_id <> '2' AND group_id='$group_id'";

	      $result = db_query($sql);

	      $names[$counter-1]=format_date("m/d/y",($end));
	      $values[$counter-1]=db_result($result, 0,0);
	    }

	  GraphIt($names, $values, _("Number of Items Still Open"));

	  echo "<p>";

	  trackers_footer(array());

	}
      else
	{

	  # It's any of the select box field.

	  $label = trackers_data_get_label($field);
	  trackers_header(array ("title"=> sprintf(_("Items by '%s'"), $label)));

	  # Make sure it is a correct field
	  if (trackers_data_is_special($field) || !trackers_data_is_used($field) ||
	      !trackers_data_is_select_box($field) )
	    {

	      echo "<h2>".sprintf(_("Can't generate report for field %s"), $label)."</h2>";

	    }
	  else
	    {

	      echo "\n<h2>".sprintf(_("Items by '%s'"), $label)."</h2>";

	      # First graph the bug distribution for Open bugs only
	      # Open means not status is neither closed (3) and nor Declined (7)
	      # and resolution is not equal to Invalid (2)
	      if ($field == 'assigned_to')
		{

		  $sql="SELECT user.user_name, count(*) AS Count FROM user,".ARTIFACT." ".
		     "WHERE user.user_id=".ARTIFACT.".assigned_to AND ".
		     "".ARTIFACT.".status_id <> '3' AND ".ARTIFACT.".status_id <> '7' AND ".
		     "".ARTIFACT.".resolution_id <> '2' AND ".ARTIFACT.".group_id='$group_id' ".
		     "GROUP BY user_name";

		}
	      else
		{

		  # make sure to include default values as well in case
		  # the project doesn't yet have its own instance of the
		  # value set and is using the default one (group_id  = '100')
		  $sql="SELECT ".ARTIFACT."_field_value.value, count(*) AS Count FROM ".ARTIFACT."_field_value,".ARTIFACT." ".
		     "WHERE ".ARTIFACT."_field_value.value_id=".ARTIFACT.".$field AND ".
		     "".ARTIFACT."_field_value.bug_field_id='".
		     trackers_data_get_field_id($field)."' AND ".
		     "(".ARTIFACT."_field_value.group_id=".ARTIFACT.".group_id OR ".ARTIFACT."_field_value.group_id='100') AND ".
		     "".ARTIFACT.".status_id <> '3' AND ".ARTIFACT.".status_id <> '7' AND ".
		     "".ARTIFACT.".resolution_id <> '2' AND ".ARTIFACT.".group_id='$group_id' ".
		     "GROUP BY value_id";

		}

	      $result=db_query($sql);
	      if ($result && db_numrows($result) > 0)
		{
		  GraphResult($result,sprintf(_("Open Bugs By '%s'"), $label));
		}
	      else
		{
		  echo "<h3>".sprintf(_("Open Items By '%s'"), $label)."</h3>";
		  echo _("No data found to report - Field probably not used");
		}
	      echo "<p>";

	      #Second  graph the bug distribution for all bugs only

	      if ($field == 'assigned_to')
		{

		  $sql="SELECT user.user_name, count(*) AS Count FROM user,bug ".
		     "WHERE user.user_id=".ARTIFACT.".assigned_to AND ".
		     "".ARTIFACT.".resolution_id <> '2' AND ".ARTIFACT.".group_id='$group_id' ".
		     "GROUP BY user_name";

		}
	      else
		{

		  $sql="SELECT ".ARTIFACT."_field_value.value, count(*) AS Count FROM ".ARTIFACT."_field_value,".ARTIFACT." ".
		     "WHERE ".ARTIFACT."_field_value.value_id=".ARTIFACT.".$field AND ".
		     "".ARTIFACT."_field_value.bug_field_id='".
		     trackers_data_get_field_id($field)."' AND ".
		     "(".ARTIFACT."_field_value.group_id=".ARTIFACT.".group_id OR ".ARTIFACT."_field_value.group_id='100') AND ".
		     "".ARTIFACT.".resolution_id <> '2' AND ".ARTIFACT.".group_id='$group_id' ".
		     "GROUP BY value_id";
		}
	      $result=db_query($sql);
	      if ($result && db_numrows($result) > 0)
		{
		  GraphResult($result,sprintf(_("All Items By %s"), $label));
		}
	      else
		{
		  echo "<h3>".sprintf(_("All Items By %s"), $label)."</h3>";
		  echo _("No data found to report - Field probably not used");
		}

	      trackers_footer(array());
	    }
	}

    }
  else
    {
      /*
	  Show main page
      */
      trackers_header(array ("title"=>_("Reporting System")));

      echo "\n<h1>"._("Item Reporting System")."</h1>";
      echo "\n<p>";
      echo "\n<a href=\"reporting.php?group_id=$group_id&field=aging\">"._("Aging Report")."</a><br />";

      while ($field = trackers_list_all_fields())
	{

	  if (trackers_data_is_special($field))
	    { continue;}

	  if (trackers_data_is_select_box($field) && trackers_data_is_used($field))
	    {

	      echo "\n<a href=\"reporting.php?group_id=$group_id&field=$field\">";
	      printf(_("Items by '%s'"), trackers_data_get_label($field));
	      echo "</a><br />\n";
	    }
	}

      trackers_footer(array());

    }

}
else
{

  #browse for group first message

  if (!$group_id)
    {
      exit_no_group();
    }
  else
    {
      exit_permission_denied();
    }

}

?>