<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: job.php,v 1.5 2004/03/13 18:22:06 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2003 (c) Free Software Foundation
#
#  Copyright 2004      (c) ...
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


function people_job_status_box($name='status_id',$checked='xyxy')
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':people_job_status_box ';
  $sql="SELECT * FROM people_job_status";
  $result=db_query($sql);
  return html_build_select_box ($result,$name,$checked);
}

function people_job_category_box($name='category_id',$checked='xyxy')
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':people_job_category_box ';
  $sql="SELECT * FROM people_job_category";
  $result=db_query($sql);
  return html_build_select_box ($result,$name,$checked);
}

function people_add_to_job_inventory($job_id,$skill_id,$skill_level_id,$skill_year_id)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':people_add_to_job_inventory($job_id,$skill_id,$skill_level_id,$skill_year_id) ';
  global $feedback;
  if (user_isloggedin())
    {
      #check if they've already added this skill
      $sql="SELECT * FROM people_job_inventory WHERE job_id='$job_id' AND skill_id='$skill_id'";
      $result=db_query($sql);
      if (!$result || db_numrows($result) < 1)
	{
	  #skill isn't already in this inventory
	  $sql="INSERT INTO people_job_inventory (job_id,skill_id,skill_level_id,skill_year_id) ".
	     "VALUES ('$job_id','$skill_id','$skill_level_id','$skill_year_id')";
	  $result=db_query($sql);
	  if (!$result || db_affected_rows($result) < 1)
	    {
	      ' ERROR inserting into skill inventory ';
	      echo db_error();
	    }
	  else
	    {
	      fb(_("Added to skill inventory "));
	    }
	}
      else
	{
	  fb(_("ERROR - skill already in your inventory "));
	}

    }
  else
    {
      echo '<h1>'._("You must be logged in first").'</h1>';
    }
}

function people_show_job_inventory($job_id)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':people_show_job_inventory($job_id) ';
  $sql="SELECT people_skill.name AS skill_name, people_skill_level.name AS level_name, people_skill_year.name AS year_name ".
     "FROM people_skill_year,people_skill_level,people_skill,people_job_inventory ".
     "WHERE people_skill_year.skill_year_id=people_job_inventory.skill_year_id ".
     "AND people_skill_level.skill_level_id=people_job_inventory.skill_level_id ".
     "AND people_skill.skill_id=people_job_inventory.skill_id ".
     "AND people_job_inventory.job_id='$job_id'";
  $result=db_query($sql);

  $title_arr=array();
  $title_arr[]=_("Skill");
  $title_arr[]=_("Level");
  $title_arr[]=_("Experience");

  echo html_build_list_table_top ($title_arr);

  $rows=db_numrows($result);
  if (!$result )  {
    echo '<tr><td><p class="warn">('._("SQL Error:").')</p>';
    echo db_error();
    echo '</td></tr>';
  } else if ( $rows < 1)
    {
      echo '<tr><td><p class="warn">('._("No Skill Inventory Set Up").')</p>';
      echo '</td></tr>';
    }
  else
    {
      for ($i=0; $i < $rows; $i++)
	{
	  echo '
			<tr class="'. utils_get_alt_row_color($i) .'">
				<td>'.db_result($result,$i,'skill_name').'</td>
				<td>'.db_result($result,$i,'level_name').'</td>
				<td>'.db_result($result,$i,'year_name').'</td></tr>';

	}
    }
  echo '
		</TABLE>';
}

function people_verify_job_group($job_id,$group_id)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':people_verify_job_group($job_id,$group_id) ';
  $sql="SELECT * FROM people_job WHERE job_id='$job_id' AND group_id='$group_id'";
  $result=db_query($sql);
  if (!$result || db_numrows($result) < 1)
    {
      return false;
    }
  else
    {
      return true;
    }
}

function people_edit_job_inventory($job_id,$group_id)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':people_edit_job_inventory($job_id,$group_id) ';

  global $PHP_SELF;
  $sql="SELECT *,people_skill.name AS skill_name FROM people_job_inventory,people_skill WHERE job_id='$job_id' AND people_skill.skill_id=people_job_inventory.skill_id";

  $result=db_query($sql);

  $title_arr=array();
  $title_arr[]='Skill';
  $title_arr[]='Level';
  $title_arr[]='Experience';
  $title_arr[]='Action';

  echo html_build_list_table_top ($title_arr);

  $rows=db_numrows($result);
  if (!$result || $rows < 1)
    {
      echo '
			<tr><td colspan="4"><h2>'._("No Skill Inventory Set Up").'</h2></td></tr>';
      echo db_error();
    }
  else
    {
      for ($i=0; $i < $rows; $i++)
	{
	  echo '
			<form action="'.$PHP_SELF.'" method="POST">
			<input type="HIDDEN" name="job_inventory_id" value="'. db_result($result,$i,'job_inventory_id') .'">
			<input type="HIDDEN" name="job_id" value="'. db_result($result,$i,'job_id') .'">
			<input type="HIDDEN" name="group_id" value="'.$group_id.'">
			<tr class="'. utils_get_alt_row_color($i) .'">
				<td><font size="-1">'. db_result($result,$i,'skill_name') . '</td>
				<td><font size="-1">'. people_skill_level_box('skill_level_id',db_result($result,$i,'skill_level_id')). '</td>
				<td><font size="-1">'. people_skill_year_box('skill_year_id',db_result($result,$i,'skill_year_id')). '</td>
				<td nowrap><font size="-1"><input type="SUBMIT" name="update_job_inventory"'
	    .'value="'._("Update").'"> &nbsp;
					<input type="SUBMIT" name="delete_from_job_inventory" value="'
	    ._("Delete").'"></td>
				</tr></form>';
	}

    }
  #add a new skill
  $i++; #for row coloring

  echo '
	<tr><td colspan="4"><h3>'._("Add A New Skill").'</h3></td></tr>
	<form action="'.$PHP_SELF.'" method="POST">
	<input type="HIDDEN" name="job_id" value="'. $job_id .'">
	<input type="HIDDEN" name="group_id" value="'.$group_id.'">
	<tr class="'. utils_get_alt_row_color($i) .'">
		<td><font size="-1">'. people_skill_box('skill_id'). '</td>
		<td><font size="-1">'. people_skill_level_box('skill_level_id'). '</td>
		<td><font size="-1">'. people_skill_year_box('skill_year_id'). '</td>
		<td nowrap><font size="-1"><input type="SUBMIT" name="add_to_job_inventory"
		value="'._("Add Skill").'"></td>
	</tr></form>';

  echo '
		</table>';
}

function people_show_job_list($result, $edit=0)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':people_show_job_list($result, $edit=0) ';
  global $sys_datefmt;
  #takes a result set from a query and shows the jobs

  #query must contain 'group_id', 'job_id', 'title', 'category_name', 'status_name' and 'type'

  $title_arr=array();
  $title_arr[]=_("Title");
  $title_arr[]=_("Category");
  $title_arr[]=_("Date Opened");
  $title_arr[]=_("Project");
  $title_arr[]=_("Type");

  $return .= html_build_list_table_top ($title_arr);

  $rows=db_numrows($result);
  if ($rows < 1)
    {
      $return .= '<tr><td colspan="3"><h2>'._("None Found").'</h2>'. db_error() .'</td></tr>';
    }
  else
    {
      for ($i=0; $i < $rows; $i++)
	{
	  # get type infos
	  $res_type = db_query("SELECT name FROM group_type WHERE type_id=".db_result($result, $i, 'type'));

	  if ($edit)
	    {
	      $page = 'editjob.php';
	    }
	  else
	    {
	      $page = 'viewjob.php';
	    }
	  $return .= '
				<tr class="'. utils_get_alt_row_color($i) .
	     '"><td><a href="'.$GLOBALS['sys_home'].'people/'.$page.'?group_id='.
	     db_result($result,$i,'group_id') .'&job_id='.
	     db_result($result,$i,'job_id') .'">'.
	     db_result($result,$i,'title') .'</a></td><td>'.
	     db_result($result,$i,'category_name') .'</td><td>'.
	     format_date($sys_datefmt,db_result($result,$i,'date')) .
	     '</td><td><a href="'.$GLOBALS['sys_home'].'projects/'.strtolower(db_result($result,$i,'unix_group_name')).'/">'.
	     db_result($result,$i,'group_name') .'</a></td><td>' .
	     db_result($res_type,0,'name') . '</td></tr>';
	}
    }

  $return .= '</table>';

  return $return;
}

function people_show_project_jobs($group_id,$edit=0)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':people_show_project_jobs($group_id,$edit=0) ';
  #show open jobs for this project
  $sql="SELECT people_job.group_id,people_job.job_id,groups.group_name,groups.unix_group_name,groups.type,people_job.title,people_job.date,people_job_category.name AS category_name ".
     "FROM people_job,people_job_category,groups ".
     "WHERE people_job.group_id='$group_id' ".
     "AND people_job.group_id=groups.group_id ".
     "AND people_job.category_id=people_job_category.category_id ".
     "AND people_job.status_id=1 ORDER BY date DESC";
  $result=db_query($sql);

  return people_show_job_list($result,$edit);
}

function people_project_jobs_rows($group_id)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':people_project_jobs_rows($group_id) ';
  #show open jobs for this project
  $sql="SELECT people_job.group_id,people_job.job_id,groups.group_name,people_job.title,people_job.date,people_job_category.name AS category_name ".
     "FROM people_job,people_job_category,groups ".
     "WHERE people_job.group_id='$group_id' ".
     "AND people_job.group_id=groups.group_id ".
     "AND people_job.category_id=people_job_category.category_id ".
     "AND people_job.status_id=1 ORDER BY date DESC";
  $result=db_query($sql);
  $rows=db_numrows($result);
  return $rows;
}

?>
