#!/bin/sh
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_non-gnu2gnu.sh,v 1.3 2004/01/31 00:56:17 yeupou Exp $ 
#
#
#
# Copyright (C) Philippe Martin <feloy@free.fr>, 2001
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# This script is useful when a project developped in Savannah 
# and initially not being a GNU project becomes a GNU project.
# Please read twice before running.
#
#
#
#
function usage 
{
  echo Usage: $0 \<projectname\>
}

# Start of script
PROJECT=$1
if [ -z $PROJECT ]; then
  usage
  exit 1
fi

# Verify that the project exists
NAME=`mysql sourceforge -B -e "select unix_group_name from groups where unix_group_name=\"$PROJECT\";" | tail -n 1`

if [ x$NAME != x$PROJECT ]; then
  echo $0: Fatal error: Project $PROJECT does not exist
  exit 1
fi

# Set the 'gnu' flag to 'Y'
GNU=`mysql sourceforge -B -e "select gnu from groups where unix_group_name=\"$PROJECT\";" | tail +2`
if [ x$GNU = xY ]; then
  echo $0: Warning: gnu is already set to Y
else
  mysql sourceforge -B -e "update groups set gnu='Y' where unix_group_name='$PROJECT';"
fi

# Set group 'type' equal to '1'
TYPE=`mysql sourceforge -B -e "select type from groups where unix_group_name=\"$PROJECT\";" | tail +2`
if [ $TYPE = 1 ]; then
  echo $0: Warning: project type is already set to 1
else
  mysql sourceforge -B -e "update groups set type='1' where unix_group_name='$PROJECT';"
fi

# Test the use of HTML CVS 
HTML_CVS=`mysql sourceforge -B -e "select html_cvs from groups where unix_group_name=\"$PROJECT\";" | tail +2`

if [ ! -z $HTML_CVS ]; then
  # Set the HTML CVS root to /software/projectname
  mysql sourceforge -B -e "update groups set html_cvs=\"/software/$PROJECT\" where unix_group_name=\"$PROJECT\";"

  # Copy the directory from non-gnu/ to software/ 
  OLDDIR=/webcvs/non-gnu/$PROJECT
  echo moving OLDDIR=$OLDDIR
  if [ -d $OLDDIR ]; then
    cd /webcvs/software ; cp -R $OLDDIR .
    chmod 2775 $PROJECT
    rm -ri $OLDDIR/*
  fi

  # Sync www.gnu.org
  echo "Syncing, please wait..."
  sv_sync_www software/$PROJECT' - New directory'
fi
