#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_checkconfig.pl,v 1.3 2004/01/31 00:56:17 yeupou Exp $
#
#
#
# Copyright (C) 2002 Loic Dachary <loic@gnu.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
#
# Check that CVSROOT/config files have the expected values, report
# problems. 
#
use strict;

#
# Point is at the beginning of the project name, run the macro to
# fix the CVSROOT/config file of the CVS tree of the project.
#
my($emacs_macro) = <<'EOF';
NUL			;; set-mark-command
C-e			;; end-of-line
C-x x			;; copy-to-register-compatibility-binding
a			;; self-insert-command
C-x C-f			;; find-file
C-a			;; beginning-of-line
C-k			;; kill-line
/cvsroot/		;; self-insert-command * 9
C-x g			;; insert-register-compatibility-binding
a			;; self-insert-command
C-e			;; end-of-line
/CVSROOT/config		;; self-insert-command * 15
RET			;; newline
ESC <			;; beginning-of-buffer
C-x C-q			;; vc-toggle-read-only
C-s			;; isearch-forward
#system			;; self-insert-command * 7
C-a			;; beginning-of-line
C-d			;; delete-char
C-s			;; isearch-forward
#lock			;; self-insert-command * 5
C-a			;; beginning-of-line
C-d			;; delete-char
C-s			;; isearch-forward
=			;; self-insert-command
ESC f			;; forward-word
ESC f			;; forward-word
ESC f			;; forward-word
/cvsroot/		;; self-insert-command * 9
C-x g			;; insert-register-compatibility-binding
a			;; self-insert-command
C-x C-s			;; save-buffer
C-x C-q			;; vc-toggle-read-only
Fix			;; self-insert-command * 3
SPC			;; self-insert-command
config			;; self-insert-command * 6
C-c C-c
EOF

my($dir);

mkdir("/tmp/$$");
chdir("/tmp/$$") or die "cannot chdir /tmp/$$";
opendir(DIR, "/cvsroot") or die "cannot opendir /cvsroot : $!";
while($dir = readdir(DIR)) {
    my(%check);

    next if($dir eq '.' || $dir eq '..' || $dir eq 'lost+found' || $dir eq 'CVSROOT' || $dir eq "common" || $dir eq "backups" || ! -d "/cvsroot/$dir");

    print "$dir ... ";

    system("co -q /cvsroot/$dir/CVSROOT/config,v");

    if(!open(CONFIG, "<config")) {
	print STDERR "open config for reading : $!";
	next;
    }

    my($line);
    while($line = <CONFIG>) {
	$check{"auth"}++ if($line =~ /^SystemAuth=no/);
	$check{"lock"}++ if($line =~ m:^LockDir=/var/lock/cvs/cvsroot/$dir:);
    }
    close(CONFIG);

    unlink("config");

    print STDERR "$dir: missing SystemAuth=no\n" if(!exists($check{"auth"}));
    print STDERR "$dir: missing LockDir=/var/lock/cvs/cvsroot/$dir\n" if(!exists($check{"lock"}));

    if(! -d "/var/lock/cvs/cvsroot/$dir") {
	print STDERR "cd /var/lock/cvs/cvsroot ; mkdir $dir ; chown anoncvs.anoncvs $dir ; chmod 777 $dir\n";
    }

    print "done\n";
}
closedir(DIR);
rmdir("/tmp/$$") or die "cannot rmdir /tmp/$$";
