/*
 * MicroEngine - A microkernel inspired game engine
 * Copyright (C) 2008 "Slinger" ("Sould Slinger" @ gorcx.net/forum),
 * _unless where otherwise stated_
 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */

#include "plugin.h"
#include <SDL/SDL.h>

struct wm_struct {
	int width;
	int height;
	char * title;
};

int window_create_preproc (char ** data, char * args)
{
	*data = calloc (1, sizeof (struct wm_struct));
	struct wm_struct * wm = (struct wm_struct *) *data;
	if ((sscanf (args, " %i %i %s", &(wm -> width), &(wm -> height), &(wm -> title))) != 3)
	{
		printf("\nIncorrect arguments for window creation!!!\n");
		return -1;
	}
	return 0;
}

void window_create (char * data)
{
	printf("* creating window\n");
	struct wm_struct * wm = (struct wm_struct *) data;
	SDL_Init(SDL_INIT_VIDEO);
	SDL_SetVideoMode (wm -> width, wm -> height, 0, 0);
	SDL_WM_SetCaption (&(wm -> title), &(wm -> title));
}

int window_destroy_preproc (char ** data, char * args)
{
	return 0;
}

void window_destroy (char * data)
{
	SDL_Quit();
}
