/*  Copyright (C) 2005-2010, Axis Communications AB, LUND, SWEDEN
 *
 *  This file is part of RAPP.
 *
 *  RAPP is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published
 *  by the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  You can use the comments under either the terms of the GNU Lesser General
 *  Public License version 3 as published by the Free Software Foundation,
 *  either version 3 of the License or (at your option) any later version, or
 *  the GNU Free Documentation License version 1.3 or any later version
 *  published by the Free Software Foundation; with no Invariant Sections, no
 *  Front-Cover Texts, and no Back-Cover Texts.
 *  A copy of the license is included in the documentation section entitled
 *  "GNU Free Documentation License".
 *
 *  RAPP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License and a copy of the GNU Free Documentation License along
 *  with RAPP. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *  @file   rc_stdbool.h
 *  @brief  RAPP Compute layer stdbool.h replacement.
 */

#ifndef RC_STDBOOL_H
#define RC_STDBOOL_H

/* Include config.h generated by configure */
#if HAVE_CONFIG_H
#include <config.h>
#endif

/* Boolean type */
#if HAVE_STDBOOL_H
#include <stdbool.h>
#else
#if !HAVE__BOOL
typedef unsigned _Bool;
#endif
#define bool  _Bool
#define true  1
#define false 0
#define __bool_true_false_are_defined 1
#endif

#endif /* RC_STDBOOL_H */
