------------------------------------------------------------------------------
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
--
-- Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
------------------------------------------------------------------------------
with Limits;
with state;
with Gui_Enum;
with Gui.Window;

package body Rapid_Helpers is

   procedure Rapid_Resize_Handler
     (Obj    : in out mcc.tki.Container.Window.Window'Class;
      Width  : in Integer;
      Height : in Integer)
   is
      use Limits;
   begin -- Rapid_Resize_Handler
      if Width < Min_Rapid_Window_Width and
         Height < Min_Rapid_Window_Height
      then
         mcc.tki.Resize
           (Obj    => mcc.tki.Sized_Object (Obj),
            Width  => Min_Rapid_Window_Width,
            Height => Min_Rapid_Window_Height);
      elsif Width < Min_Rapid_Window_Width then
         mcc.tki.Resize
           (Obj    => mcc.tki.Sized_Object (Obj),
            Width  => Min_Rapid_Window_Width,
            Height => Height);
      elsif Height < Min_Rapid_Window_Height then
         mcc.tki.Resize
           (Obj    => mcc.tki.Sized_Object (Obj),
            Width  => Width,
            Height => Min_Rapid_Window_Height);
      end if;
   end Rapid_Resize_Handler;

   function Snap (Pixel : Integer) return Integer is
      Window : Gui.Window.Window_Pointer := state.Get_Current_Window;
      Result : Integer := Pixel;
      use type Gui.Window.Window_Pointer;
      use type Gui_Enum.Snaptogrid_T;
   begin
      if Window = null or else Window.Snap = Gui_Enum.S_Off then
         return Result;
      end if;
      declare
         Snap_Size : constant Natural
            := Gui_Enum.Snaptogrid_T'Pos (Window.Snap) * 2;
         Fraction : constant Float :=  Float (Pixel) / Float (Snap_Size);
      begin
         Result := Integer (Float'Floor (Fraction)) * Snap_Size;
      end;
      return Result;
   end Snap;

end Rapid_Helpers;
