---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  GUI-WIDGET-PROGRESS.ADB
--  Description : GUI Widget Progress Bar
--
--  Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
with Gui_Enum;
with File_Helpers;
with Generate_Helpers;
with Widget_IO;
with mcc.Common_Dialogs;
with progress_dialog_Window;
with mcc.tki.Widget.Progress; use type mcc.tki.Widget.Widget_Pointer;
with mcc.tki.Colors;

package body gui.Widget.Progress is

   use type mcc.tki.Colors.Optional_Color;

   -- reads information from file into Progress,
   -- assumes keyword already read.
   procedure Read_Widget (Widget : in out Progress) is
   begin
      Read_Widget (GUI_Widget (Widget));

      Widget_IO.Get_FG_BG_Color (Widget.Color.FG, Widget.Color.BG);
   end Read_Widget;

   -- Writes information to file from Progress
   procedure Write_Widget (Widget : in Progress) is
   begin -- Write_Widget
      File_Helpers.Put (Gui_Enum.Img (Gui_Enum.Progress) & " ");
      Write_Widget (GUI_Widget (Widget));
      Widget_IO.Put_FG_BG_Color (Widget.Color.FG, Widget.Color.BG);
      File_Helpers.NL;
   end Write_Widget;

   -- wbw 6/6/99
   procedure Generate_Widget_Context_Clause (Widget : in Progress) is
   begin
      Generate_Helpers.Generate_With ("mcc.tki.Widget.Progress");
      Generate_Helpers.Generate_With ("mcc.tki.Colors");
   end Generate_Widget_Context_Clause;

   -- wbw 6/6/99
   procedure Generate_Widget_Declaration (Widget : in Progress) is
   begin
      File_Helpers.P
        (Widget.Name.all & " : aliased mcc.tki.Widget.Progress.Progress;");
   end Generate_Widget_Declaration;

   -- wbw 5/10/99
   procedure Generate_Widget_Creation
     (Widget      : in Progress;
      Window_Name : in String)
   is
      procedure P (Text : String) is
      begin
         File_Helpers.P (Text);
      end P;
   begin
      P ("mcc.tki.Widget.Progress.Create");
      P ("  (Obj     => " & Widget.Name.all & ",");
      P ("   Parent  => " & Window_Name & ",");
      P ("   X       =>" & Integer'Image (Widget.x) & ",");
      P ("   Y       =>" & Integer'Image (Widget.y) & ",");
      P ("   Width   =>" & Integer'Image (Widget.Width) & ",");
      P ("   Height  =>" & Integer'Image (Widget.Height) & ");");
      Generate_Helpers.Gen_Set_FG_BG_Color
        ("Progress", Widget.Name.all, Widget.Color.FG, Widget.Color.BG);
   end Generate_Widget_Creation;

   -- display the widget to a window
   procedure Display_Widget
     (Widget    : in out Progress;
      Container : in out mcc.tki.Container.Container'Class)
   is
   begin
      if Widget.The_Widget = null then
         Widget.The_Widget := new mcc.tki.Widget.Progress.Progress;
      end if;

      mcc.tki.Widget.Progress.Create
        (Obj    => mcc.tki.Widget.Progress.Progress (Widget.The_Widget.all),
         Parent => Container,
         X      => Widget.x,
         Y      => Widget.y,
         Width  => Widget.Width,
         Height => Widget.Height);
      if Widget.Color.FG /= mcc.tki.Colors.Default then
         mcc.tki.Widget.Set_Foreground_Color
           (Obj       => Widget.The_Widget.all,
            New_Color =>
              mcc.tki.Colors.Named_Color (Widget.Color.FG));
      end if;
      if Widget.Color.BG /= mcc.tki.Colors.Default then
         mcc.tki.Widget.Set_Background_Color
           (Obj       => Widget.The_Widget.all,
            New_Color =>
              mcc.tki.Colors.Named_Color (Widget.Color.BG));
      end if;
      mcc.tki.Widget.Progress.Set_Progress
        (Obj    => mcc.tki.Widget.Progress.Progress (Widget.The_Widget.all),
         Amount => 0.5);
      Display_Widget (GUI_Widget (Widget), Container);
   exception
      when others =>
         mcc.Common_Dialogs.Ok_Box ("Can't display: " & Widget.Name.all);
   end Display_Widget;

   procedure Set_Properties (Widget : in out Progress) is
   begin
      progress_dialog_Window.Generate_Window;
      Widget.Properties   :=
        progress_dialog_Window.progress_dialog_Window'Access;
      Widget.Name_Entry   := progress_dialog_Window.entry1'Access;
      Widget.X_Entry      := progress_dialog_Window.entry2'Access;
      Widget.Y_Entry      := progress_dialog_Window.entry3'Access;
      Widget.Width_Entry  := progress_dialog_Window.entry4'Access;
      Widget.Height_Entry := progress_dialog_Window.entry5'Access;
      Widget.Color.FG_DD  := progress_dialog_Window.fg_dd'Access;
      Widget.Color.BG_DD  := progress_dialog_Window.bg_dd'Access;
      Set_Properties (GUI_Widget (Widget));
      mcc.tki.Colors.Fill_Colors (Widget.Color);
   end Set_Properties;

   procedure Apply_Properties (Widget : in out Progress) is
   begin
      Apply_Properties (GUI_Widget (Widget));

      mcc.tki.Colors.Read_Colors (Widget.Color);
   end Apply_Properties;

   procedure Check_Properties (Widget : in out Progress; Ok : out Boolean) is
   begin
      Check_Properties (GUI_Widget (Widget), Ok);

      if not Ok then
         mcc.tki.Bell;
      end if;
   end Check_Properties;

end Gui.Widget.Progress;
