-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC TKI (ToolKit Interface) library
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
package mcc.tki.Image is
   ------------------------------------------------
   -- Image is an abstract type so that internal
   -- image types can be defined.  mcc.tki also
   -- defines an External_Image type that loads
   -- an image from a file at runtime.
   ------------------------------------------------
   type Image is abstract new Object with null record;
   type Image_Pointer is access all Image'Class;

   ------------------------------------------------
   -- procedure Create
   --
   -- create an image
   ------------------------------------------------
   procedure Create (Obj : out Image; Name : in String) is abstract;

   ------------------------------------------------
   -- use External Image to load an image from a file
   -- at runtime
   ------------------------------------------------
   type External_Image is new Image with null record;

   ------------------------------------------------
   -- procedure Create
   --
   -- create an external_image from the file of
   -- the given name
   ------------------------------------------------
   procedure Create (Obj : out External_Image; Name : in String);

end mcc.tki.Image;
