-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC TKI (ToolKit Interface) library
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with mcc.tki.Widget.Dropdown;

package body mcc.tki.Colors is

   --------------
   -- To_Color --
   --------------

   function To_Color (RGB : in RGB_Color) return Color is
   begin
      return Color'
        (Red   => Intensity ((RGB / 256 ** 2) mod 256),
         Green => Intensity ((RGB / 256) mod 256),
         Blue  => Intensity (RGB mod 256));
   end To_Color;

   function To_Color (RGB : in String) return Color is
   begin
      return To_Color (RGB_Color'Value ("16#" & RGB & "#"));
   end To_Color;

   ------------------
   -- To_RGB_Color --
   ------------------

   function To_RGB_Color (C : in Color) return RGB_Color is
   begin
      return RGB_Color (C.Red) * (256 ** 2) +
             RGB_Color (C.Green) * 256 +
             RGB_Color (C.Blue);
   end To_RGB_Color;

   procedure Read_Colors (Item : in out FG_BG_Color) is
      FG_Color : constant Natural :=
         mcc.tki.Widget.Dropdown.Get_Selected (Item.FG_DD.all);
      BG_Color : constant Natural :=
         mcc.tki.Widget.Dropdown.Get_Selected (Item.BG_DD.all);
   begin
      if FG_Color > 0 then
         Item.FG := Optional_Color'Val (FG_Color - 1);
      else
         Item.FG := Default;
      end if;
      if BG_Color > 0 then
         Item.BG := Optional_Color'Val (BG_Color - 1);
      else
         Item.BG := Default;
      end if;
   end Read_Colors;

   procedure Fill_Colors (Item : in out FG_BG_Color) is
   begin
      mcc.tki.Widget.Dropdown.Select_Item
        (Obj    => Item.BG_DD.all,
         Number => Optional_Color'Pos (Item.BG) + 1);
      mcc.tki.Widget.Dropdown.Select_Item
        (Obj    => Item.FG_DD.all,
         Number => Optional_Color'Pos (Item.FG) + 1);
   end Fill_Colors;

end mcc.tki.Colors;
